/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.components;

import java.util.List;
import org.jaudiolibs.pipes.Buffer;
import org.jaudiolibs.pipes.Pipe;
import org.praxislive.audio.code.AudioCodeDelegate;
import org.praxislive.audio.code.userapi.AudioIn;
import org.praxislive.audio.code.userapi.AudioOut;
import org.praxislive.code.userapi.AuxOut;
import org.praxislive.code.userapi.In;
import org.praxislive.code.userapi.Out;
import org.praxislive.code.userapi.Output;

public class AudioLevel
extends AudioCodeDelegate {
    static final String TEMPLATE_PATH = "resources/audio_level.pxj";
    @In(value=1)
    AudioIn in;
    @Out(value=1)
    AudioOut out;
    @AuxOut(value=1)
    Output level;
    private float[] cache;

    public void init() {
        this.link(new Pipe[]{this.in, new AudioMeasure(), this.out});
    }

    public void update() {
        if (this.cache != null) {
            this.level.send(this.calculateRMS(this.cache));
        } else {
            this.level.send(0);
        }
    }

    private double calculateRMS(float[] buffer) {
        double ret = 0.0;
        for (float sample : buffer) {
            ret += (double)(sample * sample);
        }
        return Math.sqrt(ret /= (double)buffer.length);
    }

    private class AudioMeasure
    extends Pipe {
        AudioMeasure() {
            super(1, 1);
        }

        protected void process(List<Buffer> list) {
            Buffer buffer = list.get(0);
            float[] audio = buffer.getData();
            int size = buffer.getSize();
            if (AudioLevel.this.cache == null || AudioLevel.this.cache.length != size) {
                AudioLevel.this.cache = new float[size];
            }
            System.arraycopy(audio, 0, AudioLevel.this.cache, 0, size);
        }
    }
}

