/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.impl.components;

import org.jaudiolibs.pipes.Pipe;
import org.jaudiolibs.pipes.Placeholder;
import org.praxislive.audio.AudioContext;
import org.praxislive.audio.AudioPort;
import org.praxislive.audio.ClientRegistrationException;
import org.praxislive.audio.DefaultAudioInputPort;
import org.praxislive.base.AbstractComponent;
import org.praxislive.base.AbstractProperty;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Control;
import org.praxislive.core.Info;
import org.praxislive.core.Port;
import org.praxislive.core.Value;
import org.praxislive.core.protocols.ComponentProtocol;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PNumber;

public class AudioOutput
extends AbstractComponent {
    private static final int MAX_CHANNELS = 16;
    private final Placeholder[] placeholders = new Placeholder[16];
    private final AudioPort.Input[] ports;
    private final AudioContext.OutputClient client;
    private int channelCount;
    private AudioContext context;
    private ComponentInfo info;

    public AudioOutput() {
        for (int i = 0; i < 16; ++i) {
            this.placeholders[i] = new Placeholder();
        }
        this.ports = new AudioPort.Input[16];
        this.client = new Client();
        this.channelCount = 2;
        this.registerControl("channels", (Control)new ChannelProperty());
        this.syncPorts();
    }

    public void hierarchyChanged() {
        super.hierarchyChanged();
        AudioContext ctxt = this.getLookup().find(AudioContext.class).orElse(null);
        if (ctxt != this.context) {
            if (this.context != null) {
                this.context.unregisterAudioOutputClient(this.client);
                this.context = null;
            }
            if (ctxt == null) {
                return;
            }
            try {
                ctxt.registerAudioOutputClient(this.client);
                this.context = ctxt;
            }
            catch (ClientRegistrationException ex) {
                System.getLogger(AudioOutput.class.getName()).log(System.Logger.Level.ERROR, "", (Throwable)ex);
            }
        }
    }

    private void syncPorts() {
        for (int i = 0; i < 16; ++i) {
            if (i < this.channelCount) {
                if (this.ports[i] != null) continue;
                DefaultAudioInputPort port = new DefaultAudioInputPort((Pipe)this.placeholders[i]);
                this.registerPort("in-" + (i + 1), (Port)port);
                this.ports[i] = port;
                continue;
            }
            if (this.ports[i] == null) continue;
            this.unregisterPort("in-" + (i + 1));
            this.ports[i] = null;
        }
        this.info = null;
    }

    public ComponentInfo getInfo() {
        if (this.info == null) {
            this.info = Info.component(cmp -> {
                cmp.merge(ComponentProtocol.API_INFO);
                cmp.property("dynamic", (Object)PBoolean.TRUE);
                cmp.control("channels", c -> c.property().input(a -> a.number().min(1.0).max(16.0).property("is-integer", (Value)PBoolean.TRUE)));
                for (int i = 0; i < this.channelCount; ++i) {
                    cmp.port("in-" + (i + 1), p -> p.input(AudioPort.class));
                }
                return cmp;
            });
        }
        return this.info;
    }

    private class ChannelProperty
    extends AbstractProperty {
        PNumber value = PNumber.of((int)2);

        private ChannelProperty() {
        }

        protected void set(long time, Value arg) throws Exception {
            this.value = PNumber.from((Value)arg).filter(n -> n.toIntValue() >= 1 && n.toIntValue() <= 16).orElseThrow(IllegalArgumentException::new);
            AudioOutput.this.channelCount = this.value.toIntValue();
            AudioOutput.this.syncPorts();
        }

        protected Value get() {
            return this.value;
        }
    }

    private class Client
    extends AudioContext.OutputClient {
        private Client() {
        }

        public int getOutputCount() {
            return AudioOutput.this.channelCount;
        }

        public Pipe getOutputSource(int index) {
            return AudioOutput.this.placeholders[index];
        }
    }
}

