/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.components;

import org.praxislive.audio.code.AudioCodeDelegate;
import org.praxislive.code.userapi.Config;
import org.praxislive.code.userapi.Inject;
import org.praxislive.code.userapi.OnChange;
import org.praxislive.code.userapi.Out;
import org.praxislive.code.userapi.Output;
import org.praxislive.code.userapi.P;
import org.praxislive.code.userapi.ReadOnly;
import org.praxislive.code.userapi.Type;

public class AudioClock
extends AudioCodeDelegate {
    static final String TEMPLATE_PATH = "resources/clock.pxj";
    @P(value=1)
    @Type.Number(min=10.0, max=300.0, def=120.0)
    @Config.Port(value=false)
    @OnChange(value="updatePulse")
    double bpm;
    @P(value=2)
    @Type.Integer(min=1, max=16, def=4)
    @OnChange(value="updatePulse")
    int subdivision;
    @P(value=3)
    @ReadOnly
    double actualBpm;
    @P(value=4)
    @ReadOnly
    double period;
    @P(value=5)
    @ReadOnly
    int bufferCount;
    @Out(value=1)
    Output out;
    @Inject
    int position;

    public void init() {
        this.updatePulse();
    }

    public void update() {
        ++this.position;
        if (this.position > this.bufferCount) {
            this.position = 0;
            this.out.send();
        }
    }

    void updatePulse() {
        double secPerPulse = 1.0 / (this.bpm * (double)this.subdivision / 60.0);
        double bufPerPulse = secPerPulse / ((double)this.blockSize / this.sampleRate);
        this.bufferCount = (int)(bufPerPulse + 0.5);
        this.period = (double)this.bufferCount * ((double)this.blockSize / this.sampleRate);
        this.actualBpm = (double)(60 / this.subdivision) * (1.0 / this.period);
    }
}

