/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.components;

import org.praxislive.audio.code.AudioCode;
import org.praxislive.audio.code.AudioCodeDelegate;
import org.praxislive.audio.components.AudioClock;
import org.praxislive.audio.components.AudioCustom;
import org.praxislive.audio.components.AudioFXChorus;
import org.praxislive.audio.components.AudioFXCombFilter;
import org.praxislive.audio.components.AudioFXDelay;
import org.praxislive.audio.components.AudioFXFilter;
import org.praxislive.audio.components.AudioFXLFODelay;
import org.praxislive.audio.components.AudioFXOverdrive;
import org.praxislive.audio.components.AudioFXReverb;
import org.praxislive.audio.components.AudioGain;
import org.praxislive.audio.components.AudioLevel;
import org.praxislive.audio.components.AudioLooper;
import org.praxislive.audio.components.AudioOsc;
import org.praxislive.audio.components.AudioPlayer;
import org.praxislive.code.AbstractComponentFactory;
import org.praxislive.core.services.ComponentFactory;
import org.praxislive.core.services.ComponentFactoryProvider;

public class AudioComponents
implements ComponentFactoryProvider {
    private static final Factory instance = new Factory();

    public ComponentFactory getFactory() {
        return instance;
    }

    private static class Factory
    extends AbstractComponentFactory {
        private Factory() {
            this.build();
        }

        private void build() {
            this.add("audio:custom", AudioCustom.class, "resources/custom.pxj");
            this.add("audio:clock", AudioClock.class, "resources/clock.pxj");
            this.add("audio:gain", AudioGain.class, "resources/gain.pxj");
            this.add("audio:osc", AudioOsc.class, "resources/osc.pxj");
            this.add("audio:player", AudioPlayer.class, "resources/player.pxj");
            this.add("audio:looper", AudioLooper.class, "resources/looper.pxj");
            this.add("audio:fx:chorus", AudioFXChorus.class, "resources/fx_chorus.pxj");
            this.add("audio:fx:comb-filter", AudioFXCombFilter.class, "resources/fx_comb_filter.pxj");
            this.add("audio:fx:delay", AudioFXDelay.class, "resources/fx_delay.pxj");
            this.add("audio:fx:filter", AudioFXFilter.class, "resources/fx_filter.pxj");
            this.add("audio:fx:lfo-delay", AudioFXLFODelay.class, "resources/fx_lfo_delay.pxj");
            this.add("audio:fx:overdrive", AudioFXOverdrive.class, "resources/fx_overdrive.pxj");
            this.add("audio:fx:reverb", AudioFXReverb.class, "resources/fx_reverb.pxj");
            this.add("audio:analysis:level", AudioLevel.class, "resources/audio_level.pxj");
        }

        private void add(String type, Class<? extends AudioCodeDelegate> cls, String path) {
            this.add(AudioCode.base().create(type, cls, this.source(path)));
        }
    }
}

