/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.components;

import org.jaudiolibs.pipes.Pipe;
import org.jaudiolibs.pipes.units.IIRFilter;
import org.praxislive.audio.code.AudioCodeDelegate;
import org.praxislive.audio.code.userapi.AudioIn;
import org.praxislive.audio.code.userapi.AudioOut;
import org.praxislive.audio.code.userapi.UGen;
import org.praxislive.code.userapi.In;
import org.praxislive.code.userapi.Out;
import org.praxislive.code.userapi.P;
import org.praxislive.code.userapi.Property;
import org.praxislive.code.userapi.Type;

public class AudioFXFilter
extends AudioCodeDelegate {
    static final String TEMPLATE_PATH = "resources/fx_filter.pxj";
    @In(value=1)
    AudioIn in1;
    @In(value=2)
    AudioIn in2;
    @Out(value=1)
    AudioOut out1;
    @Out(value=2)
    AudioOut out2;
    @UGen
    IIRFilter f1;
    @UGen
    IIRFilter f2;
    @P(value=1)
    @Type.String(allowed={"LP6", "LP12", "HP12", "BP12", "NP12", "LP24", "HP24"})
    Property type;
    @P(value=2)
    @Type.Number(min=20.0, max=20000.0, def=20000.0, skew=2.0)
    Property frequency;
    @P(value=3)
    @Type.Number(min=0.0, max=30.0, skew=2.0)
    Property resonance;

    public void init() {
        this.type.linkAs(arg -> IIRFilter.Type.valueOf((String)arg.toString()), type -> {
            this.f1.type(type);
            this.f2.type(type);
        });
        this.frequency.link(arg_0 -> ((IIRFilter)this.f1).frequency(arg_0)).link(arg_0 -> ((IIRFilter)this.f2).frequency(arg_0));
        this.resonance.link(arg_0 -> ((IIRFilter)this.f1).resonance(arg_0)).link(arg_0 -> ((IIRFilter)this.f2).resonance(arg_0));
        this.link(new Pipe[]{this.in1, this.f1, this.out1});
        this.link(new Pipe[]{this.in2, this.f2, this.out2});
    }
}

