/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.components;

import org.jaudiolibs.pipes.Pipe;
import org.jaudiolibs.pipes.units.AudioTable;
import org.jaudiolibs.pipes.units.Looper;
import org.praxislive.audio.code.AudioCodeDelegate;
import org.praxislive.audio.code.userapi.AudioIn;
import org.praxislive.audio.code.userapi.AudioOut;
import org.praxislive.audio.code.userapi.UGen;
import org.praxislive.code.userapi.In;
import org.praxislive.code.userapi.Inject;
import org.praxislive.code.userapi.OnChange;
import org.praxislive.code.userapi.Out;
import org.praxislive.code.userapi.P;
import org.praxislive.code.userapi.Property;
import org.praxislive.code.userapi.Ref;
import org.praxislive.code.userapi.T;
import org.praxislive.code.userapi.Transient;
import org.praxislive.code.userapi.Type;
import org.praxislive.core.Value;
import org.praxislive.core.types.PBoolean;

public class AudioLooper
extends AudioCodeDelegate {
    static final String TEMPLATE_PATH = "resources/looper.pxj";
    final double MAX_BUFFER_SECONDS = 5.0;
    @In(value=1)
    AudioIn in1;
    @In(value=2)
    AudioIn in2;
    @Out(value=1)
    AudioOut out1;
    @Out(value=2)
    AudioOut out2;
    @UGen
    Looper looper;
    @P(value=1)
    @OnChange(value="updateState")
    boolean recording;
    @P(value=2)
    @Type.Number(min=0.0, max=1.0)
    @Transient
    @OnChange(value="updatePosition")
    double position;
    @P(value=3)
    @Type.Number(min=0.0, max=1.0)
    Property start;
    @P(value=4)
    @Type.Number(min=0.0, max=1.0, def=1.0)
    Property end;
    @P(value=5)
    @Type.Number(min=-4.0, max=4.0, def=1.0)
    Property speed;
    @P(value=6)
    @Type.Boolean(def=true)
    Property loop;
    @P(value=7)
    @Transient
    @OnChange(value="updateState")
    boolean playing;
    @P(value=8)
    @Type.Number(min=0.0, max=5.0, def=5.0)
    Property loopSize;
    @Inject
    Ref<AudioTable> table;

    public void init() {
        this.table.init(() -> AudioTable.generate((int)((int)(5.0 * this.sampleRate)), (int)2));
        this.loopSize.doubles().link(s -> this.looper.table(AudioTable.wrap((AudioTable)((AudioTable)this.table.get()), (int)((int)(s * this.sampleRate)))));
        this.start.link(arg_0 -> ((Looper)this.looper).in(arg_0));
        this.end.link(arg_0 -> ((Looper)this.looper).out(arg_0));
        this.speed.link(arg_0 -> ((Looper)this.looper).speed(arg_0));
        this.loop.linkAs(arg -> ((PBoolean)PBoolean.from((Value)arg).get()).value(), arg_0 -> ((Looper)this.looper).looping(arg_0));
        this.link(new Pipe[]{this.in1, this.looper, this.out1});
        this.link(new Pipe[]{this.in2, this.looper, this.out2});
        this.updateState();
    }

    public void update() {
        this.position = this.looper.position();
        this.playing = this.looper.playing();
    }

    @T(value=1)
    void play() {
        this.looper.play();
    }

    @T(value=2)
    void stop() {
        this.looper.stop();
    }

    void updatePosition() {
        this.looper.position(this.position);
    }

    void updateState() {
        this.looper.playing(this.playing);
        this.looper.recording(this.recording);
    }
}

