/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.components;

import org.jaudiolibs.pipes.Pipe;
import org.jaudiolibs.pipes.units.AudioTable;
import org.jaudiolibs.pipes.units.Player;
import org.praxislive.audio.code.AudioCodeDelegate;
import org.praxislive.audio.code.userapi.AudioOut;
import org.praxislive.audio.code.userapi.UGen;
import org.praxislive.code.userapi.AuxOut;
import org.praxislive.code.userapi.OnChange;
import org.praxislive.code.userapi.OnError;
import org.praxislive.code.userapi.Out;
import org.praxislive.code.userapi.Output;
import org.praxislive.code.userapi.P;
import org.praxislive.code.userapi.Property;
import org.praxislive.code.userapi.T;
import org.praxislive.code.userapi.Transient;
import org.praxislive.code.userapi.Type;
import org.praxislive.core.Value;
import org.praxislive.core.types.PBoolean;

public class AudioPlayer
extends AudioCodeDelegate {
    static final String TEMPLATE_PATH = "resources/player.pxj";
    @Out(value=1)
    AudioOut out1;
    @Out(value=2)
    AudioOut out2;
    @UGen
    Player pl;
    @P(value=1)
    @OnChange(value="sampleChanged")
    @OnError(value="sampleError")
    AudioTable sample;
    @P(value=2)
    @Type.Number(min=0.0, max=1.0)
    @Transient
    @OnChange(value="updatePosition")
    double position;
    @P(value=3)
    @Type.Number(min=0.0, max=1.0)
    Property start;
    @P(value=4)
    @Type.Number(min=0.0, max=1.0, def=1.0)
    Property end;
    @P(value=5)
    @Type.Number(min=-4.0, max=4.0, def=1.0)
    Property speed;
    @P(value=6)
    @Type.Boolean
    Property loop;
    @P(value=7)
    @Transient
    @OnChange(value="updatePlaying")
    boolean playing;
    @AuxOut(value=1)
    Output ready;
    @AuxOut(value=2)
    Output error;

    public void init() {
        this.pl.table(this.sample);
        this.start.link(arg_0 -> ((Player)this.pl).in(arg_0));
        this.end.link(arg_0 -> ((Player)this.pl).out(arg_0));
        this.speed.link(arg_0 -> ((Player)this.pl).speed(arg_0));
        this.loop.linkAs(arg -> ((PBoolean)PBoolean.from((Value)arg).get()).value(), arg_0 -> ((Player)this.pl).looping(arg_0));
        this.link(new Pipe[]{this.pl, this.out1});
        this.link(new Pipe[]{this.pl, this.out2});
    }

    public void update() {
        this.position = this.pl.position();
        this.playing = this.pl.playing();
    }

    @T(value=1)
    void play() {
        this.pl.play();
    }

    @T(value=2)
    void stop() {
        this.pl.stop();
    }

    void updatePosition() {
        this.pl.position(this.position);
    }

    void updatePlaying() {
        this.pl.playing(this.playing);
    }

    void sampleChanged() {
        this.pl.table(this.sample);
        this.ready.send();
    }

    void sampleError() {
        this.error.send();
    }
}

