/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.impl.components;

import org.jaudiolibs.pipes.Pipe;
import org.jaudiolibs.pipes.Placeholder;
import org.praxislive.audio.AudioContext;
import org.praxislive.audio.AudioPort;
import org.praxislive.audio.ClientRegistrationException;
import org.praxislive.audio.DefaultAudioOutputPort;
import org.praxislive.base.AbstractComponent;
import org.praxislive.base.AbstractProperty;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Control;
import org.praxislive.core.Info;
import org.praxislive.core.Port;
import org.praxislive.core.TreeWriter;
import org.praxislive.core.Value;
import org.praxislive.core.protocols.ComponentProtocol;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PNumber;

public class AudioInput
extends AbstractComponent {
    private static final int MAX_CHANNELS = 16;
    private final Placeholder[] placeholders = new Placeholder[16];
    private final AudioPort.Output[] ports;
    private final AudioContext.InputClient client;
    private int channelCount;
    private AudioContext context;
    private ComponentInfo info;

    public AudioInput() {
        for (int i = 0; i < 16; ++i) {
            this.placeholders[i] = new Placeholder();
        }
        this.ports = new AudioPort.Output[16];
        this.client = new Client();
        this.channelCount = 2;
        this.registerControl("channels", (Control)new ChannelProperty());
        this.syncPorts();
    }

    public void hierarchyChanged() {
        super.hierarchyChanged();
        AudioContext ctxt = this.getLookup().find(AudioContext.class).orElse(null);
        if (ctxt != this.context) {
            if (this.context != null) {
                this.context.unregisterAudioInputClient(this.client);
                this.context = null;
            }
            if (ctxt == null) {
                return;
            }
            try {
                ctxt.registerAudioInputClient(this.client);
                this.context = ctxt;
            }
            catch (ClientRegistrationException ex) {
                System.getLogger(AudioInput.class.getName()).log(System.Logger.Level.ERROR, "", (Throwable)ex);
            }
        }
    }

    private void syncPorts() {
        for (int i = 0; i < 16; ++i) {
            if (i < this.channelCount) {
                if (this.ports[i] != null) continue;
                DefaultAudioOutputPort port = new DefaultAudioOutputPort((Pipe)this.placeholders[i]);
                this.registerPort("out-" + (i + 1), (Port)port);
                this.ports[i] = port;
                continue;
            }
            if (this.ports[i] == null) continue;
            this.unregisterPort("out-" + (i + 1));
            this.ports[i] = null;
        }
        this.info = null;
    }

    public ComponentInfo getInfo() {
        if (this.info == null) {
            this.info = Info.component(cmp -> {
                cmp.merge(ComponentProtocol.API_INFO);
                cmp.property("component-type", (Object)ComponentType.of((String)"audio:input"));
                cmp.property("dynamic", (Object)PBoolean.TRUE);
                cmp.control("channels", c -> c.property().input(a -> a.number().min(1.0).max(16.0).property("is-integer", (Object)PBoolean.TRUE)).defaultValue((Value)PNumber.of((int)2)));
                for (int i = 0; i < this.channelCount; ++i) {
                    cmp.port("out-" + (i + 1), p -> p.output(AudioPort.class));
                }
                return cmp;
            });
        }
        return this.info;
    }

    public void write(TreeWriter writer) {
        super.write(writer);
        if (this.channelCount != 2) {
            writer.writeProperty("channels", (Value)PNumber.of((int)this.channelCount));
        }
    }

    private class Client
    extends AudioContext.InputClient {
        private Client() {
        }

        public int getInputCount() {
            return AudioInput.this.channelCount;
        }

        public Pipe getInputSink(int index) {
            return AudioInput.this.placeholders[index];
        }
    }

    private class ChannelProperty
    extends AbstractProperty {
        PNumber value = PNumber.of((int)2);

        private ChannelProperty() {
        }

        protected void set(long time, Value arg) throws Exception {
            this.value = PNumber.from((Value)arg).filter(n -> n.toIntValue() >= 1 && n.toIntValue() <= 16).orElseThrow(IllegalArgumentException::new);
            AudioInput.this.channelCount = this.value.toIntValue();
            AudioInput.this.syncPorts();
        }

        protected Value get() {
            return this.value;
        }
    }
}

