/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio.impl.components;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jaudiolibs.audioservers.AudioClient;
import org.jaudiolibs.audioservers.AudioConfiguration;
import org.jaudiolibs.audioservers.AudioServer;
import org.jaudiolibs.audioservers.AudioServerProvider;
import org.jaudiolibs.audioservers.ext.ClientID;
import org.jaudiolibs.audioservers.ext.Device;
import org.jaudiolibs.pipes.client.PipesAudioClient;
import org.praxislive.audio.AudioContext;
import org.praxislive.audio.AudioSettings;
import org.praxislive.audio.ClientRegistrationException;
import org.praxislive.base.AbstractProperty;
import org.praxislive.base.AbstractRoot;
import org.praxislive.base.AbstractRootContainer;
import org.praxislive.base.DefaultExecutionContext;
import org.praxislive.core.Clock;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Control;
import org.praxislive.core.Info;
import org.praxislive.core.Lookup;
import org.praxislive.core.Value;
import org.praxislive.core.protocols.ComponentProtocol;
import org.praxislive.core.protocols.ContainerProtocol;
import org.praxislive.core.protocols.StartableProtocol;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PString;

public class DefaultAudioRoot
extends AbstractRootContainer {
    private static final Logger LOG = Logger.getLogger(DefaultAudioRoot.class.getName());
    private static final int MAX_CHANNELS = 16;
    private static final int MIN_SAMPLERATE = 2000;
    private static final int MAX_SAMPLERATE = 192000;
    private static final int DEFAULT_SAMPLERATE = 48000;
    private static final int MAX_BLOCKSIZE = 512;
    private static final int DEFAULT_BLOCKSIZE = 64;
    private final CheckedIntProperty sampleRate;
    private final CheckedIntProperty blockSize;
    private final LibraryProperty audioLib;
    private final CheckedStringProperty clientName;
    private final CheckedIntProperty extBufferSize;
    private final DeviceProperty deviceName;
    private final DeviceProperty inputDeviceName;
    private final TimingModeProperty timingMode;
    private final ComponentInfo baseInfo;
    private final AudioContext audioCtxt;
    private ComponentInfo info;
    private Map<String, LibraryInfo> libraries;
    private AudioContext.InputClient inputClient;
    private AudioContext.OutputClient outputClient;
    private PipesAudioClient bus;
    private AudioDelegate delegate;
    private AudioServer server;
    private Lookup lookup;
    private long period = -1L;

    public DefaultAudioRoot() {
        this.extractLibraryInfo();
        this.sampleRate = new CheckedIntProperty(2000, 192000, 48000);
        this.registerControl("sample-rate", (Control)this.sampleRate);
        this.blockSize = new CheckedIntProperty(1, 512, 64);
        this.registerControl("block-size", (Control)this.blockSize);
        this.clientName = new CheckedStringProperty((Value)PString.EMPTY);
        this.registerControl("client-name", (Control)this.clientName);
        this.audioLib = new LibraryProperty();
        this.registerControl("library", (Control)this.audioLib);
        this.deviceName = new DeviceProperty();
        this.inputDeviceName = new DeviceProperty();
        this.extBufferSize = new CheckedIntProperty(1, 48000, AudioSettings.getBuffersize());
        this.timingMode = new TimingModeProperty();
        this.info = this.baseInfo = Info.component(cmp -> cmp.merge(ComponentProtocol.API_INFO).merge(ContainerProtocol.API_INFO).merge(StartableProtocol.API_INFO).control("sample-rate", c -> c.property().defaultValue((Value)PNumber.of((int)48000)).input(a -> a.number().min(2000.0).max(192000.0).property("is-integer", (Value)PBoolean.TRUE))).control("block-size", c -> c.property().defaultValue((Value)PNumber.of((int)64)).input(a -> a.number().min(1.0).max(512.0).property("is-integer", (Value)PBoolean.TRUE))).control("client-name", c -> c.property().defaultValue((Value)PString.EMPTY).input(a -> a.string())).control("library", c -> c.property().defaultValue((Value)PString.EMPTY).input(a -> a.string().emptyIsDefault().allowed((String[])Stream.concat(Stream.of(""), this.libraries.keySet().stream().sorted()).toArray(String[]::new)))).property("dynamic", (Object)PBoolean.TRUE));
        this.audioCtxt = new AudioCtxt();
    }

    private void extractLibraryInfo() {
        AudioServerProvider[] providers;
        this.libraries = new LinkedHashMap<String, LibraryInfo>();
        ArrayList<Device> devices = new ArrayList<Device>();
        ArrayList<Device> inputDevices = new ArrayList<Device>();
        for (AudioServerProvider lib : providers = (AudioServerProvider[])Lookup.SYSTEM.findAll(AudioServerProvider.class).toArray(AudioServerProvider[]::new)) {
            LOG.log(Level.FINE, "Audio Library : {0}", lib.getLibraryName());
            devices.clear();
            inputDevices.clear();
            for (Device device : lib.findAll(Device.class)) {
                if (device.getMaxOutputChannels() > 0) {
                    LOG.log(Level.FINE, "-- Found device : {0}", device.getName());
                    devices.add(device);
                    continue;
                }
                if (device.getMaxInputChannels() <= 0) continue;
                LOG.log(Level.FINE, "-- Found input device : {0}", device.getName());
                inputDevices.add(device);
            }
            this.libraries.put(lib.getLibraryName(), new LibraryInfo(lib, List.copyOf(devices), List.copyOf(inputDevices)));
        }
    }

    private void updateLibrary(String lib) {
        this.unregisterControl("device");
        this.unregisterControl("input-device");
        this.unregisterControl("ext-buffer-size");
        this.unregisterControl("timing-mode");
        this.info = this.baseInfo;
        if (lib.isEmpty()) {
            return;
        }
        LibraryInfo libInfo = this.libraries.get(lib);
        if (libInfo == null) {
            return;
        }
        if (!"JACK".equals(lib)) {
            this.registerControl("device", (Control)this.deviceName);
            this.registerControl("input-device", (Control)this.inputDeviceName);
            this.registerControl("ext-buffer-size", (Control)this.extBufferSize);
            this.registerControl("timing-mode", (Control)this.timingMode);
            this.info = Info.component(cmp -> cmp.merge(this.baseInfo).control("device", c -> c.property().defaultValue((Value)PString.EMPTY).input(a -> a.string().suggested(this.deviceNames(libInfo.devices)).emptyIsDefault())).control("input-device", c -> c.property().defaultValue((Value)PString.EMPTY).input(a -> a.string().suggested(this.deviceNames(libInfo.devices)).emptyIsDefault())).control("ext-buffer-size", c -> c.property().input(a -> ((Info.NumberInfoBuilder)a.number().property("is-integer", (Value)PBoolean.TRUE)).property("suggested-values", (Value)PArray.of((Value[])new Value[]{PNumber.of((int)64), PNumber.of((int)128), PNumber.of((int)256), PNumber.of((int)512), PNumber.of((int)1024), PNumber.of((int)2048), PNumber.of((int)4096)})))).control("timing-mode", c -> c.property().defaultValue((Value)PString.of((String)"Blocking")).input(a -> a.string().allowed(new String[]{"Blocking", "Estimated", "FramePosition"}))));
        }
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = Lookup.of((Lookup)super.getLookup(), (Object[])new Object[]{this.audioCtxt});
        }
        return this.lookup;
    }

    protected DefaultExecutionContext createContext(long initialTime) {
        return new Context(initialTime);
    }

    protected void starting() {
        try {
            if (this.outputClient == null) {
                this.setIdle();
            }
            this.bus = new PipesAudioClient(this.blockSize.value.toIntValue(), this.inputClient == null ? 0 : this.inputClient.getInputCount(), this.outputClient.getOutputCount());
            this.delegate = new AudioDelegate(this.getRootHub().getClock());
            this.bus.addListener((PipesAudioClient.Listener)this.delegate);
            if (this.inputClient != null) {
                this.makeInputConnections();
            }
            this.makeOutputConnections();
            this.server = this.createServer(this.bus);
            this.attachDelegate(this.delegate);
            this.delegate.start();
        }
        catch (Exception ex) {
            Logger.getLogger(DefaultAudioRoot.class.getName()).log(Level.SEVERE, null, ex);
            this.setIdle();
        }
    }

    private AudioServer createServer(PipesAudioClient bus) throws Exception {
        String id;
        float srate = this.sampleRate.value.toIntValue();
        int buffersize = this.getBuffersize();
        boolean usingDefault = false;
        LibraryInfo libInfo = this.libraries.get(this.audioLib.value.value());
        if (libInfo == null) {
            libInfo = this.libraries.get(AudioSettings.getLibrary());
            if (libInfo == null) {
                throw new IllegalStateException("Audio library not found");
            }
            usingDefault = true;
        }
        LOG.log(Level.FINE, "Found audio library {0}\n{1}", new Object[]{libInfo.provider.getLibraryName(), libInfo.provider.getLibraryDescription()});
        Device device = this.findDevice(libInfo, usingDefault, false);
        if (device != null) {
            LOG.log(Level.FINE, "Found device : {0}", device.getName());
        }
        Device inputDevice = null;
        if (device != null && device.getMaxInputChannels() == 0 && bus.getSourceCount() > 0 && (inputDevice = this.findDevice(libInfo, usingDefault, true)) != null) {
            LOG.log(Level.FINE, "Found input device : {0}", inputDevice.getName());
        }
        ClientID clientID = (id = this.clientName.value.toString()).isBlank() ? new ClientID("PraxisCORE-" + this.getAddress().rootID()) : new ClientID(id);
        Object timing = this.findTimingMode(this.timingMode.value.toString());
        AudioConfiguration ctxt = new AudioConfiguration(srate, bus.getSourceCount(), bus.getSinkCount(), buffersize, timing == null ? this.createCheckedExts(device, inputDevice, clientID) : this.createCheckedExts(device, inputDevice, clientID, timing));
        return libInfo.provider.createServer(ctxt, (AudioClient)bus);
    }

    private int getBuffersize() {
        int bsize;
        int req = this.extBufferSize == null ? AudioSettings.getBuffersize() : this.extBufferSize.value.toIntValue();
        int block = this.blockSize.value.toIntValue();
        if (req < 1 || block < 1) {
            throw new IllegalArgumentException("Buffer / block values out of range");
        }
        if (block > req) {
            return block;
        }
        for (bsize = block; bsize < req; bsize += block) {
        }
        LOG.log(Level.FINE, "Requesting buffersize of : {0}", bsize);
        return bsize;
    }

    private Device findDevice(LibraryInfo info, boolean usingDefault, boolean input) {
        String name = null;
        if (usingDefault) {
            name = input ? AudioSettings.getInputDeviceName() : AudioSettings.getDeviceName();
        } else if (input) {
            name = this.inputDeviceName == null ? null : this.inputDeviceName.value.value();
        } else {
            String string = name = this.deviceName == null ? null : this.deviceName.value.value();
        }
        if (name == null || name.trim().isEmpty()) {
            return null;
        }
        List<Device> devices = input ? info.inputDevices : info.devices;
        for (Device device : devices) {
            if (!device.getName().equals(name)) continue;
            return device;
        }
        for (Device device : devices) {
            if (!device.getName().contains(name)) continue;
            return device;
        }
        return null;
    }

    private void validateDevices() {
        if (this.deviceName == null || this.inputDeviceName == null) {
            return;
        }
        LibraryInfo libInfo = this.libraries.get(this.audioLib.value.value());
        if (libInfo == null) {
            return;
        }
        Device primary = this.findDevice(libInfo, false, false);
        if (primary != null && primary.getMaxInputChannels() > 0) {
            this.inputDeviceName.value = PString.EMPTY;
        }
    }

    private String[] deviceNames(List<Device> devices) {
        String[] names = new String[devices.size() + 1];
        names[0] = "";
        for (int i = 0; i < devices.size(); ++i) {
            names[i + 1] = devices.get(i).getName();
        }
        return names;
    }

    private Object findTimingMode(String mode) {
        try {
            Class<?> modeClass = Class.forName("org.jaudiolibs.audioservers.javasound.JSTimingMode");
            return Enum.valueOf(modeClass.asSubclass(Enum.class), mode);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Object[] createCheckedExts(Object ... exts) {
        ArrayList<Object> lst = new ArrayList<Object>(exts.length);
        for (Object o : exts) {
            if (o == null) continue;
            lst.add(o);
        }
        return lst.toArray();
    }

    private void makeInputConnections() {
        int count = Math.min(this.inputClient.getInputCount(), this.bus.getSourceCount());
        for (int i = 0; i < count; ++i) {
            this.inputClient.getInputSink(i).addSource(this.bus.getSource(i));
        }
    }

    private void makeOutputConnections() {
        int count = Math.min(this.outputClient.getOutputCount(), this.bus.getSinkCount());
        for (int i = 0; i < count; ++i) {
            this.bus.getSink(i).addSource(this.outputClient.getOutputSource(i));
        }
    }

    protected void stopping() {
        if (this.bus == null) {
            return;
        }
        this.server.shutdown();
        this.bus.disconnectAll();
        this.bus.removeListener((PipesAudioClient.Listener)this.delegate);
        this.server = null;
        this.bus = null;
        this.delegate = null;
        this.interrupt();
    }

    protected void terminating() {
        super.terminating();
        AudioServer s = this.server;
        this.server = null;
        if (s != null) {
            s.shutdown();
        }
        PipesAudioClient b = this.bus;
        this.bus = null;
        if (b != null) {
            b.disconnectAll();
        }
    }

    public ComponentInfo getInfo() {
        return this.info;
    }

    private static class LibraryInfo {
        private final AudioServerProvider provider;
        private final List<Device> devices;
        private final List<Device> inputDevices;

        private LibraryInfo(AudioServerProvider provider, List<Device> devices, List<Device> inputDevices) {
            this.provider = provider;
            this.devices = devices;
            this.inputDevices = inputDevices;
        }
    }

    private class TimingModeProperty
    extends AbstractProperty {
        private PString value = PString.of((String)"Blocking");

        private TimingModeProperty() {
        }

        protected void set(long time, Value arg) throws Exception {
            if (DefaultAudioRoot.this.getState() == AbstractRoot.State.ACTIVE_RUNNING) {
                throw new IllegalStateException("Can't set value while active");
            }
            switch (arg.toString()) {
                case "Blocking": 
                case "Estimated": 
                case "FramePosition": {
                    this.value = PString.of((Object)arg);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown timing mode value " + arg);
                }
            }
        }

        protected Value get() {
            return this.value;
        }
    }

    private class DeviceProperty
    extends AbstractProperty {
        private PString value = PString.EMPTY;

        private DeviceProperty() {
        }

        protected void set(long time, Value arg) throws Exception {
            if (DefaultAudioRoot.this.getState() == AbstractRoot.State.ACTIVE_RUNNING) {
                throw new IllegalStateException("Can't set value while active");
            }
            PString value = PString.from((Value)arg).orElse(PString.EMPTY);
            if (this.value.equals((Object)value)) {
                return;
            }
            this.value = value;
            DefaultAudioRoot.this.validateDevices();
        }

        protected Value get() {
            return this.value;
        }
    }

    private class LibraryProperty
    extends AbstractProperty {
        private PString value = PString.EMPTY;

        private LibraryProperty() {
        }

        protected void set(long time, Value arg) throws Exception {
            if (DefaultAudioRoot.this.getState() == AbstractRoot.State.ACTIVE_RUNNING) {
                throw new IllegalStateException("Can't set value while active");
            }
            PString value = PString.from((Value)arg).orElse(PString.EMPTY);
            if (this.value.equals((Object)value)) {
                return;
            }
            if (value.isEmpty() || DefaultAudioRoot.this.libraries.containsKey(value.toString())) {
                this.value = value;
                DefaultAudioRoot.this.updateLibrary(value.toString());
            }
        }

        protected Value get() {
            return this.value;
        }
    }

    private class CheckedStringProperty
    extends AbstractProperty {
        private Value value;

        private CheckedStringProperty(Value initial) {
            this.value = initial;
        }

        protected void set(long time, Value arg) throws Exception {
            if (DefaultAudioRoot.this.getState() == AbstractRoot.State.ACTIVE_RUNNING) {
                throw new IllegalStateException("Can't set value while active");
            }
            this.value = arg;
        }

        protected Value get() {
            return this.value;
        }
    }

    private class CheckedIntProperty
    extends AbstractProperty {
        private final int MIN;
        private final int MAX;
        private PNumber value;

        private CheckedIntProperty(int min, int max, int initial) {
            this.value = PNumber.of((int)initial);
            this.MIN = min;
            this.MAX = max;
        }

        protected void set(long time, Value arg) throws Exception {
            if (DefaultAudioRoot.this.getState() == AbstractRoot.State.ACTIVE_RUNNING) {
                throw new IllegalStateException("Can't set value while active");
            }
            PNumber val = (PNumber)PNumber.from((Value)arg).orElseThrow(IllegalArgumentException::new);
            if (!val.isInteger()) {
                val = PNumber.of((int)val.toIntValue());
            }
            if (val.toIntValue() < this.MIN || val.toIntValue() > this.MAX) {
                throw new IllegalArgumentException("Out of range");
            }
            this.value = val;
        }

        protected Value get() {
            return this.value;
        }
    }

    private class Context
    extends DefaultExecutionContext {
        private Context(long time) {
            super(time);
        }

        public OptionalLong getPeriod() {
            return OptionalLong.of(DefaultAudioRoot.this.period);
        }
    }

    private class AudioCtxt
    extends AudioContext {
        private AudioCtxt() {
        }

        @Override
        public int registerAudioInputClient(AudioContext.InputClient client) throws ClientRegistrationException {
            if (DefaultAudioRoot.this.inputClient != null) {
                throw new ClientRegistrationException();
            }
            DefaultAudioRoot.this.inputClient = client;
            return 16;
        }

        @Override
        public void unregisterAudioInputClient(AudioContext.InputClient client) {
            if (DefaultAudioRoot.this.inputClient == client) {
                DefaultAudioRoot.this.inputClient = null;
                if (DefaultAudioRoot.this.bus != null) {
                    DefaultAudioRoot.this.bus.disconnectAll();
                    DefaultAudioRoot.this.makeOutputConnections();
                }
            }
        }

        @Override
        public int registerAudioOutputClient(AudioContext.OutputClient client) throws ClientRegistrationException {
            if (DefaultAudioRoot.this.outputClient != null) {
                throw new ClientRegistrationException();
            }
            DefaultAudioRoot.this.outputClient = client;
            return 16;
        }

        @Override
        public void unregisterAudioOutputClient(AudioContext.OutputClient client) {
            if (DefaultAudioRoot.this.outputClient == client) {
                DefaultAudioRoot.this.outputClient = null;
                if (DefaultAudioRoot.this.bus != null) {
                    DefaultAudioRoot.this.bus.disconnectAll();
                    DefaultAudioRoot.this.setIdle();
                }
            }
        }

        @Override
        public double getSampleRate() {
            return DefaultAudioRoot.this.sampleRate.value.value();
        }

        @Override
        public int getBlockSize() {
            return DefaultAudioRoot.this.blockSize.value.toIntValue();
        }
    }

    private class AudioDelegate
    extends AbstractRoot.Delegate
    implements PipesAudioClient.Listener {
        private final long offset;

        private AudioDelegate(Clock clock) {
            super((AbstractRoot)DefaultAudioRoot.this);
            this.offset = System.nanoTime() - clock.getTime();
        }

        public void configure(AudioConfiguration context) throws Exception {
            float srate = context.getSampleRate();
            if (Math.round(srate) != DefaultAudioRoot.this.sampleRate.value.toIntValue()) {
                DefaultAudioRoot.this.sampleRate.value = PNumber.of((int)Math.round(srate));
            }
            DefaultAudioRoot.this.period = (long)(DefaultAudioRoot.this.blockSize.value.value() / (double)srate * 1.0E9);
        }

        public void process() {
            try {
                boolean ok = this.doUpdate(DefaultAudioRoot.this.bus.getTime() - this.offset);
                if (!ok && DefaultAudioRoot.this.server != null) {
                    DefaultAudioRoot.this.server.shutdown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void shutdown() {
            DefaultAudioRoot.this.period = -1L;
        }

        private void start() {
            Thread runner = this.getThreadFactory().newThread(() -> {
                try {
                    DefaultAudioRoot.this.server.run();
                }
                catch (Exception ex) {
                    Logger.getLogger(DefaultAudioRoot.class.getName()).log(Level.SEVERE, null, ex);
                }
                DefaultAudioRoot.this.setIdle();
                DefaultAudioRoot.this.detachDelegate(this);
            });
            runner.start();
        }
    }
}

