/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio;

import org.praxislive.core.Settings;

public class AudioSettings {
    public static final String KEY_LIBRARY = "audio.library";
    public static final String KEY_DEVICE = "audio.device";
    public static final String KEY_BUFFERSIZE = "audio.buffersize";
    public static final String KEY_INPUT_DEVICE = "audio.input-device";
    private static final int DEFAULT_BUFFERSIZE = 2048;
    private static final String DEFAULT_LIBRARY = "JavaSound";

    private AudioSettings() {
    }

    public static String getLibrary() {
        return Settings.get((String)KEY_LIBRARY, (String)DEFAULT_LIBRARY);
    }

    public static void setLibrary(String library) {
        Settings.put((String)KEY_LIBRARY, (String)library);
    }

    public static int getBuffersize() {
        return Settings.getInt((String)KEY_BUFFERSIZE, (int)2048);
    }

    public static void setBuffersize(int buffersize) {
        Settings.putInt((String)KEY_BUFFERSIZE, (int)buffersize);
    }

    public static String getDeviceName() {
        return Settings.get((String)KEY_DEVICE, (String)"");
    }

    public static void setDeviceName(String device) {
        if (device == null || device.trim().isEmpty()) {
            Settings.put((String)KEY_DEVICE, null);
        } else {
            Settings.put((String)KEY_DEVICE, (String)device);
        }
    }

    public static String getInputDeviceName() {
        return Settings.get((String)KEY_INPUT_DEVICE, (String)"");
    }

    public static void setInputDeviceName(String inputDevice) {
        if (inputDevice == null || inputDevice.trim().isEmpty()) {
            Settings.put((String)KEY_INPUT_DEVICE, null);
        } else {
            Settings.put((String)KEY_INPUT_DEVICE, (String)inputDevice);
        }
    }
}

