/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio;

import java.util.stream.Stream;
import org.jaudiolibs.pipes.Pipe;
import org.praxislive.core.Port;
import org.praxislive.core.PortConnectionException;
import org.praxislive.core.PortInfo;
import org.praxislive.core.types.PMap;

public abstract class AudioPort
implements Port {

    public static class Provider
    implements Port.TypeProvider {
        public Stream<Port.Type<?>> types() {
            return Stream.of(new Port.Type(AudioPort.class));
        }
    }

    public static abstract class Output
    extends AudioPort {
        private PortInfo info;

        public Output() {
            this(PMap.EMPTY);
        }

        public Output(PMap properties) {
            this.info = PortInfo.create(AudioPort.class, (PortInfo.Direction)PortInfo.Direction.OUT, (PMap)properties);
        }

        public final PortInfo getInfo() {
            return this.info;
        }

        protected final void makeConnection(Input port, Pipe source) throws PortConnectionException {
            port.addAudioOutputPort(this, source);
        }

        protected final void breakConnection(Input port, Pipe source) {
            port.removeAudioOutputPort(this, source);
        }
    }

    public static abstract class Input
    extends AudioPort {
        private PortInfo info;

        public Input() {
            this(PMap.EMPTY);
        }

        public Input(PMap properties) {
            this.info = PortInfo.create(AudioPort.class, (PortInfo.Direction)PortInfo.Direction.IN, (PMap)properties);
        }

        public final void connect(Port port) throws PortConnectionException {
            if (!(port instanceof Output)) {
                throw new PortConnectionException();
            }
            port.connect((Port)this);
        }

        public final void disconnect(Port port) {
            if (port instanceof Output) {
                port.disconnect((Port)this);
            }
        }

        public final PortInfo getInfo() {
            return this.info;
        }

        protected abstract void addAudioOutputPort(Output var1, Pipe var2) throws PortConnectionException;

        protected abstract void removeAudioOutputPort(Output var1, Pipe var2);
    }
}

