/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jaudiolibs.pipes.Add;
import org.jaudiolibs.pipes.Pipe;
import org.praxislive.audio.AudioPort;
import org.praxislive.core.Port;
import org.praxislive.core.PortConnectionException;
import org.praxislive.core.PortListener;

public class DefaultAudioInputPort
extends AudioPort.Input {
    private static final System.Logger LOG = System.getLogger(DefaultAudioInputPort.class.getName());
    private final List<AudioPort.Output> connections;
    private final List<PortListener> listeners;
    private Pipe sink;
    private Pipe portSink;
    private Add mixer;
    private boolean multiChannelCapable;

    public DefaultAudioInputPort(Pipe sink) {
        this(sink, false);
    }

    public DefaultAudioInputPort(Pipe sink, boolean multiChannelCapable) {
        if (sink == null) {
            throw new NullPointerException();
        }
        this.sink = sink;
        this.portSink = sink;
        this.multiChannelCapable = multiChannelCapable;
        this.connections = new ArrayList<AudioPort.Output>();
        this.listeners = new CopyOnWriteArrayList<PortListener>();
    }

    public void disconnectAll() {
        for (AudioPort.Output connection : this.connections()) {
            this.disconnect(connection);
        }
    }

    public List<AudioPort.Output> connections() {
        return List.copyOf(this.connections);
    }

    public void addListener(PortListener listener) {
        this.listeners.add(Objects.requireNonNull(listener));
    }

    public void removeListener(PortListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected void addAudioOutputPort(AudioPort.Output port, Pipe source) throws PortConnectionException {
        if (this.connections.contains(port)) {
            throw new PortConnectionException();
        }
        if (this.connections.size() == 1) {
            this.switchToMultichannel();
        }
        try {
            this.portSink.addSource(source);
            this.connections.add(port);
            this.listeners.forEach(l -> l.connectionsChanged((Port)this));
        }
        catch (Exception ex) {
            if (this.connections.size() == 1) {
                this.switchToSingleChannel();
            }
            throw new PortConnectionException();
        }
    }

    @Override
    protected void removeAudioOutputPort(AudioPort.Output port, Pipe source) {
        if (this.connections.remove(port)) {
            this.portSink.removeSource(source);
            if (this.connections.size() == 1) {
                this.switchToSingleChannel();
            }
            this.listeners.forEach(l -> l.connectionsChanged((Port)this));
        }
    }

    private void switchToMultichannel() {
        if (this.multiChannelCapable || this.portSink == this.mixer) {
            return;
        }
        Pipe[] sources = this.removeSources(this.sink);
        try {
            if (this.mixer == null) {
                this.mixer = new Add(16);
            }
            this.sink.addSource((Pipe)this.mixer);
            for (Pipe source : sources) {
                this.mixer.addSource(source);
            }
            this.portSink = this.mixer;
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.WARNING, "Error converting port to multi channel", (Throwable)ex);
            this.removeSources((Pipe)this.mixer);
            this.removeSources(this.sink);
            this.connections.clear();
            this.listeners.forEach(l -> l.connectionsChanged((Port)this));
        }
    }

    private void switchToSingleChannel() {
        if (this.portSink == this.sink) {
            return;
        }
        Pipe[] sources = this.removeSources((Pipe)this.mixer);
        try {
            this.sink.removeSource((Pipe)this.mixer);
            for (Pipe source : sources) {
                this.sink.addSource(source);
            }
            this.portSink = this.sink;
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.WARNING, "Error converting port to single channel", (Throwable)ex);
            this.removeSources(this.sink);
            this.removeSources((Pipe)this.mixer);
            this.connections.clear();
            this.listeners.forEach(l -> l.connectionsChanged((Port)this));
        }
    }

    private Pipe[] removeSources(Pipe sink) {
        Pipe[] sources = new Pipe[sink.getSourceCount()];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = sink.getSource(i);
        }
        for (Pipe source : sources) {
            sink.removeSource(source);
        }
        return sources;
    }
}

