/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.audio;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jaudiolibs.pipes.Pipe;
import org.jaudiolibs.pipes.Tee;
import org.praxislive.audio.AudioPort;
import org.praxislive.core.Port;
import org.praxislive.core.PortConnectionException;
import org.praxislive.core.PortListener;

public class DefaultAudioOutputPort
extends AudioPort.Output {
    private static final System.Logger LOG = System.getLogger(DefaultAudioOutputPort.class.getName());
    private final List<AudioPort.Input> connections;
    private final List<PortListener> listeners;
    private Pipe source;
    private Pipe portSource;
    private Tee splitter;
    private boolean multiChannelCapable;

    public DefaultAudioOutputPort(Pipe source) {
        this(source, false);
    }

    public DefaultAudioOutputPort(Pipe source, boolean multiChannelCapable) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.portSource = source;
        this.multiChannelCapable = multiChannelCapable;
        this.connections = new ArrayList<AudioPort.Input>();
        this.listeners = new CopyOnWriteArrayList<PortListener>();
    }

    public void connect(Port port) throws PortConnectionException {
        if (port instanceof AudioPort.Input) {
            AudioPort.Input aport = (AudioPort.Input)port;
            if (this.connections.contains(aport)) {
                throw new PortConnectionException();
            }
            if (this.connections.size() == 1) {
                this.switchToMultichannel();
            }
            AudioPort.Input ip = (AudioPort.Input)port;
            try {
                this.makeConnection(ip, this.portSource);
                this.connections.add(ip);
            }
            catch (PortConnectionException ex) {
                if (this.connections.size() == 1) {
                    this.switchToSingleChannel();
                }
                throw ex;
            }
        } else {
            throw new PortConnectionException();
        }
        this.listeners.forEach(l -> l.connectionsChanged((Port)this));
    }

    public void disconnect(Port port) {
        AudioPort.Input aport;
        if (port instanceof AudioPort.Input && this.connections.contains(aport = (AudioPort.Input)port)) {
            this.breakConnection(aport, this.portSource);
            this.connections.remove(aport);
            if (this.connections.size() == 1) {
                this.switchToSingleChannel();
            }
            this.listeners.forEach(l -> l.connectionsChanged((Port)this));
        }
    }

    public void disconnectAll() {
        for (AudioPort.Input port : this.connections()) {
            this.disconnect(port);
        }
    }

    public List<AudioPort.Input> connections() {
        return List.copyOf(this.connections);
    }

    public void addListener(PortListener listener) {
        this.listeners.add(Objects.requireNonNull(listener));
    }

    public void removeListener(PortListener listener) {
        this.listeners.remove(listener);
    }

    private void switchToMultichannel() {
        if (this.multiChannelCapable || this.portSource == this.splitter) {
            return;
        }
        Pipe[] sinks = this.removeSinks(this.source);
        try {
            if (this.splitter == null) {
                this.splitter = new Tee(16);
            }
            this.splitter.addSource(this.source);
            for (Pipe sink : sinks) {
                sink.addSource((Pipe)this.splitter);
            }
            this.portSource = this.splitter;
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.WARNING, "Error converting port to multi channel", (Throwable)ex);
            this.removeSinks((Pipe)this.splitter);
            this.removeSinks(this.source);
            this.portSource = this.source;
            this.connections.clear();
        }
    }

    private void switchToSingleChannel() {
        if (this.portSource == this.source) {
            return;
        }
        Pipe[] sinks = this.removeSinks((Pipe)this.splitter);
        try {
            this.splitter.removeSource(this.source);
            for (Pipe sink : sinks) {
                sink.addSource(this.source);
            }
            this.portSource = this.source;
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.WARNING, "Error converting port to single channel", (Throwable)ex);
            this.removeSinks(this.source);
            this.removeSinks((Pipe)this.splitter);
            this.portSource = this.source;
            this.connections.clear();
        }
    }

    private Pipe[] removeSinks(Pipe source) {
        Pipe[] sinks = new Pipe[source.getSinkCount()];
        for (int i = 0; i < sinks.length; ++i) {
            sinks[i] = source.getSink(i);
        }
        for (Pipe sink : sinks) {
            sink.removeSource(source);
        }
        return sinks;
    }
}

