/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.praxislive.core.Component;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Lookup;
import org.praxislive.core.Root;
import org.praxislive.core.services.ComponentFactory;
import org.praxislive.core.services.ComponentInstantiationException;

public class AbstractComponentFactory
implements ComponentFactory {
    private final Map<ComponentType, MetaDataEx<? extends Component>> componentMap = new LinkedHashMap<ComponentType, MetaDataEx<? extends Component>>();
    private final Map<ComponentType, MetaDataEx<? extends Root>> rootMap = new LinkedHashMap<ComponentType, MetaDataEx<? extends Root>>(1);

    protected AbstractComponentFactory() {
    }

    public Stream<ComponentType> componentTypes() {
        return this.componentMap.keySet().stream();
    }

    public Stream<ComponentType> rootTypes() {
        return this.rootMap.keySet().stream();
    }

    public Component createComponent(ComponentType type) throws ComponentInstantiationException {
        MetaDataEx<? extends Component> data = this.componentMap.get(type);
        if (data == null) {
            throw new IllegalArgumentException();
        }
        try {
            Class<? extends Component> cl = data.getComponentClass();
            return cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new ComponentInstantiationException((Throwable)ex);
        }
    }

    public Root createRootComponent(ComponentType type) throws ComponentInstantiationException {
        MetaDataEx<? extends Root> data = this.rootMap.get(type);
        if (data == null) {
            throw new IllegalArgumentException();
        }
        try {
            Class<? extends Root> cl = data.getComponentClass();
            return cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new ComponentInstantiationException((Throwable)ex);
        }
    }

    public ComponentFactory.MetaData<? extends Component> getMetaData(ComponentType type) {
        return this.componentMap.get(type);
    }

    public ComponentFactory.MetaData<? extends Root> getRootMetaData(ComponentType type) {
        return this.rootMap.get(type);
    }

    protected void add(String type, Class<? extends Component> cls) {
        this.add(type, AbstractComponentFactory.data(cls));
    }

    protected void add(String type, Data<? extends Component> info) {
        this.componentMap.put(ComponentType.of((String)type), info.toMetaData());
    }

    protected void addRoot(String type, Class<? extends Root> cls) {
        this.addRoot(type, AbstractComponentFactory.data(cls));
    }

    protected void addRoot(String type, Data<? extends Root> info) {
        this.rootMap.put(ComponentType.of((String)type), info.toMetaData());
    }

    public static <T> Data<T> data(Class<T> cls) {
        return new Data<T>(cls);
    }

    public static class Data<T> {
        private final Class<T> cls;
        private boolean test;
        private boolean deprecated;
        private ComponentType replacement;
        private List<Object> lookupList;

        private Data(Class<T> cls) {
            this.cls = cls;
        }

        public Data<T> test() {
            this.test = true;
            return this;
        }

        public Data<T> deprecated() {
            this.deprecated = true;
            return this;
        }

        public Data<T> replacement(String type) {
            this.replacement = ComponentType.of((String)type);
            this.deprecated = true;
            return this;
        }

        public Data<T> add(Object obj) {
            if (this.lookupList == null) {
                this.lookupList = new ArrayList<Object>();
            }
            this.lookupList.add(obj);
            return this;
        }

        private MetaDataEx<T> toMetaData() {
            return new MetaDataEx<T>(this.cls, this.test, this.deprecated, this.replacement, this.lookupList == null ? null : Lookup.of((Object[])this.lookupList.toArray()));
        }
    }

    private static class MetaDataEx<T>
    extends ComponentFactory.MetaData<T> {
        private final Class<T> cls;
        private final boolean test;
        private final boolean deprecated;
        private final ComponentType replacement;
        private final Lookup lookup;

        private MetaDataEx(Class<T> cls, boolean test, boolean deprecated, ComponentType replacement, Lookup lookup) {
            this.cls = cls;
            this.test = test;
            this.deprecated = deprecated;
            this.replacement = replacement;
            this.lookup = lookup;
        }

        public Class<T> getComponentClass() {
            return this.cls;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public Optional<ComponentType> findReplacement() {
            return Optional.ofNullable(this.replacement);
        }

        public Lookup getLookup() {
            return this.lookup == null ? super.getLookup() : this.lookup;
        }
    }
}

