/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.stream.Stream;
import org.praxislive.base.AbstractContainer;
import org.praxislive.base.AbstractRoot;
import org.praxislive.core.Call;
import org.praxislive.core.Component;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Container;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Lookup;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Port;
import org.praxislive.core.PortConnectionException;
import org.praxislive.core.Value;
import org.praxislive.core.VetoException;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PError;

public abstract class AbstractRootContainer
extends AbstractRoot
implements Container {
    private final ContainerImpl delegate = new ContainerImpl(this);

    protected AbstractRootContainer() {
        this.registerControl("start", (call, router) -> {
            this.setRunning();
            router.route((Packet)call.reply());
        });
        this.registerControl("stop", (call, router) -> {
            this.setIdle();
            router.route((Packet)call.reply());
        });
        this.registerControl("is-running", (call, router) -> router.route((Packet)call.reply((Value)PBoolean.of((this.getState() == AbstractRoot.State.ACTIVE_RUNNING ? 1 : 0) != 0))));
    }

    public Component getChild(String id) {
        return this.delegate.getChild(id);
    }

    public Stream<String> children() {
        return this.delegate.children();
    }

    public ComponentAddress getAddress(Component child) {
        return this.delegate.getAddress(child);
    }

    public Container getParent() {
        return null;
    }

    public void parentNotify(Container parent) throws VetoException {
        throw new VetoException();
    }

    public void hierarchyChanged() {
    }

    public Control getControl(String id) {
        return this.delegate.getControl(id);
    }

    public Port getPort(String id) {
        return this.delegate.getPort(id);
    }

    public abstract ComponentInfo getInfo();

    @Override
    protected void processCall(Call call, PacketRouter router) {
        block5: {
            Control control = this.findControl(call.to());
            try {
                if (control != null) {
                    control.call(call, router);
                } else if (call.isRequest()) {
                    router.route((Packet)call.error(PError.of((String)("Unknown control address : " + call.to()))));
                }
            }
            catch (Exception ex) {
                if (!call.isRequest()) break block5;
                router.route((Packet)call.error(PError.of((Exception)ex)));
            }
        }
    }

    protected final void addChild(String id, Component child) throws VetoException {
        this.delegate.addChild(id, child);
    }

    protected final Component removeChild(String id) {
        return this.delegate.removeChild(id);
    }

    protected final void connect(String component1, String port1, String component2, String port2) throws PortConnectionException {
        this.delegate.connect(component1, port1, component2, port2);
    }

    protected final void disconnect(String component1, String port1, String component2, String port2) {
        this.delegate.disconnect(component1, port1, component2, port2);
    }

    protected final void registerControl(String id, Control control) {
        this.delegate.registerControl(id, control);
    }

    protected final void unregisterControl(String id) {
        this.delegate.unregisterControl(id);
    }

    private Control findControl(ControlAddress address) {
        Component comp = this.findComponent(address.component());
        if (comp != null) {
            return comp.getControl(address.controlID());
        }
        return null;
    }

    private Component findComponent(ComponentAddress address) {
        ContainerImpl comp = this.delegate;
        for (int i = 1; i < address.depth(); ++i) {
            if (!(comp instanceof Container)) {
                return null;
            }
            comp = ((Container)comp).getChild(address.componentID(i));
        }
        return comp;
    }

    private static class ContainerImpl
    extends AbstractContainer {
        private final AbstractRootContainer wrapper;

        private ContainerImpl(AbstractRootContainer wrapper) {
            this.wrapper = wrapper;
        }

        public ComponentInfo getInfo() {
            return this.wrapper.getInfo();
        }

        @Override
        public Lookup getLookup() {
            return this.wrapper.getLookup();
        }

        @Override
        protected ComponentAddress getAddress() {
            return this.wrapper.getAddress();
        }

        @Override
        protected void notifyChild(Component child) throws VetoException {
            child.parentNotify((Container)this.wrapper);
        }
    }
}

