/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.List;
import java.util.Optional;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;

public abstract class Binding {
    public abstract Optional<ControlInfo> getControlInfo();

    public abstract List<Value> getValues();

    protected abstract void send(Adaptor var1, List<Value> var2);

    protected abstract void updateAdaptorConfiguration(Adaptor var1);

    protected void bind(Adaptor adaptor) {
        adaptor.setBinding(this);
    }

    protected void unbind(Adaptor adaptor) {
        adaptor.setBinding(null);
    }

    public static abstract class Adaptor {
        private Binding binding;
        private SyncRate syncRate = SyncRate.None;
        private boolean active;

        private void setBinding(Binding binding) {
            this.binding = binding;
            this.updateBindingConfiguration();
        }

        public final Binding getBinding() {
            return this.binding;
        }

        public final SyncRate getSyncRate() {
            return this.syncRate;
        }

        public final boolean isActive() {
            return this.active;
        }

        public final void setActive(boolean active) {
            if (active != this.active) {
                this.active = active;
                if (this.binding != null) {
                    this.binding.updateAdaptorConfiguration(this);
                }
            }
        }

        public final void setSyncRate(SyncRate syncRate) {
            if (syncRate != this.syncRate) {
                this.syncRate = syncRate;
                if (this.binding != null) {
                    this.binding.updateAdaptorConfiguration(this);
                }
            }
        }

        protected final void send(List<Value> args) {
            if (this.binding != null) {
                this.binding.send(this, args);
            }
        }

        protected boolean getValueIsAdjusting() {
            return false;
        }

        protected void onResponse(List<Value> args) {
        }

        protected void onError(List<Value> args) {
        }

        protected void updateBindingConfiguration() {
        }

        protected void update() {
        }
    }

    public static enum SyncRate {
        None,
        Low,
        Medium,
        High;

    }
}

