/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.base.Binding;
import org.praxislive.base.BindingContext;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.ExecutionContext;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Value;

public class BindingContextControl
implements Control,
BindingContext {
    private static final Logger LOG = Logger.getLogger(BindingContextControl.class.getName());
    private static final long LOW_SYNC_DELAY = TimeUnit.MILLISECONDS.toNanos(1000L);
    private static final long MED_SYNC_DELAY = TimeUnit.MILLISECONDS.toNanos(200L);
    private static final long HIGH_SYNC_DELAY = TimeUnit.MILLISECONDS.toNanos(50L);
    private static final long INVOKE_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(5000L);
    private static final long QUIET_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(200L);
    private final ExecutionContext context;
    private final PacketRouter router;
    private final ControlAddress controlAddress;
    private final Map<ControlAddress, BindingImpl> bindings;
    private final BindingSyncQueue syncQueue;

    public BindingContextControl(ControlAddress controlAddress, ExecutionContext context, PacketRouter router) {
        this.controlAddress = Objects.requireNonNull(controlAddress);
        this.context = Objects.requireNonNull(context);
        this.router = Objects.requireNonNull(router);
        this.bindings = new LinkedHashMap<ControlAddress, BindingImpl>();
        this.syncQueue = new BindingSyncQueue(context.getTime());
        context.addClockListener(this::tick);
    }

    @Override
    public void bind(ControlAddress address, Binding.Adaptor adaptor) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(adaptor);
        BindingImpl binding = this.bindings.computeIfAbsent(address, x$0 -> new BindingImpl((ControlAddress)x$0));
        binding.addAdaptor(adaptor);
    }

    @Override
    public void unbind(ControlAddress address, Binding.Adaptor adaptor) {
        BindingImpl binding = this.bindings.get(address);
        if (binding != null) {
            binding.removeAdaptor(adaptor);
            if (binding.isEmpty()) {
                this.bindings.remove(address);
            }
        }
    }

    public void call(Call call, PacketRouter router) throws Exception {
        if (call.isReply() || call.isError()) {
            if (call.from().controlID().equals("info")) {
                ComponentAddress infoOf = call.from().component();
                this.bindings.forEach((a, b) -> {
                    if (infoOf.equals((Object)a.component())) {
                        b.process(call);
                    }
                });
            } else {
                BindingImpl binding = this.bindings.get(call.from());
                if (binding != null) {
                    binding.process(call);
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void tick(ExecutionContext source) {
        BindingImpl b;
        this.syncQueue.setTime(source.getTime());
        while ((b = this.syncQueue.poll()) != null) {
            b.processSync();
        }
    }

    private class BindingImpl
    extends Binding {
        private final List<Binding.Adaptor> adaptors = new ArrayList<Binding.Adaptor>();
        private final ControlAddress boundAddress;
        private ControlInfo bindingInfo;
        private long syncPeriod;
        private int infoMatchID;
        private boolean isProperty;
        private Call activeCall;
        private Binding.Adaptor activeAdaptor;
        private List<Value> values;

        private BindingImpl(ControlAddress boundAddress) {
            this.boundAddress = boundAddress;
            this.values = Collections.emptyList();
        }

        private void addAdaptor(Binding.Adaptor adaptor) {
            if (adaptor == null) {
                throw new NullPointerException();
            }
            if (this.adaptors.contains(adaptor)) {
                return;
            }
            this.adaptors.add(adaptor);
            this.bind(adaptor);
            this.updateAdaptorConfiguration(adaptor);
            if (this.bindingInfo == null) {
                this.sendInfoRequest();
            }
        }

        private void removeAdaptor(Binding.Adaptor adaptor) {
            if (this.adaptors.remove(adaptor)) {
                this.unbind(adaptor);
            }
            this.updateSyncConfiguration();
        }

        private boolean isEmpty() {
            return this.adaptors.isEmpty();
        }

        @Override
        protected void send(Binding.Adaptor adaptor, List<Value> args) {
            Call call = adaptor.getValueIsAdjusting() ? Call.createQuiet((ControlAddress)this.boundAddress, (ControlAddress)BindingContextControl.this.controlAddress, (long)BindingContextControl.this.context.getTime(), args) : Call.create((ControlAddress)this.boundAddress, (ControlAddress)BindingContextControl.this.controlAddress, (long)BindingContextControl.this.context.getTime(), args);
            BindingContextControl.this.router.route((Packet)call);
            this.activeCall = call;
            this.activeAdaptor = adaptor;
            this.values = args;
            for (Binding.Adaptor ad : this.adaptors) {
                if (ad == adaptor) continue;
                ad.update();
            }
        }

        @Override
        protected void updateAdaptorConfiguration(Binding.Adaptor adaptor) {
            this.updateSyncConfiguration();
        }

        private void updateSyncConfiguration() {
            if (this.isProperty) {
                LOG.log(Level.FINE, "Updating sync configuration on {0}", this.boundAddress);
                boolean active = false;
                Binding.SyncRate highRate = Binding.SyncRate.None;
                for (Binding.Adaptor a : this.adaptors) {
                    if (!a.isActive()) continue;
                    active = true;
                    Binding.SyncRate aRate = a.getSyncRate();
                    if (aRate.compareTo(highRate) <= 0) continue;
                    highRate = aRate;
                }
                if (!active || highRate == Binding.SyncRate.None) {
                    this.syncPeriod = 0L;
                } else {
                    this.syncPeriod = this.delayForRate(highRate);
                    this.processSync();
                }
            } else {
                this.syncPeriod = 0L;
            }
        }

        private long delayForRate(Binding.SyncRate rate) {
            switch (rate) {
                case Low: {
                    return LOW_SYNC_DELAY;
                }
                case Medium: {
                    return MED_SYNC_DELAY;
                }
                case High: {
                    return HIGH_SYNC_DELAY;
                }
            }
            throw new IllegalArgumentException();
        }

        private void sendInfoRequest() {
            ControlAddress toAddress = ControlAddress.of((ComponentAddress)this.boundAddress.component(), (String)"info");
            Call call = Call.create((ControlAddress)toAddress, (ControlAddress)BindingContextControl.this.controlAddress, (long)BindingContextControl.this.context.getTime());
            this.infoMatchID = call.matchID();
            BindingContextControl.this.router.route((Packet)call);
        }

        private void processInfo(Call call) {
            List args;
            if (call.matchID() == this.infoMatchID && (args = call.args()).size() > 0) {
                ComponentInfo compInfo = null;
                try {
                    compInfo = (ComponentInfo)ComponentInfo.from((Value)((Value)args.get(0))).get();
                    this.bindingInfo = compInfo.controlInfo(this.boundAddress.controlID());
                    ControlInfo.Type type = this.bindingInfo.controlType();
                    this.isProperty = type == ControlInfo.Type.Property || type == ControlInfo.Type.ReadOnlyProperty;
                }
                catch (Exception ex) {
                    this.isProperty = false;
                    this.bindingInfo = null;
                    LOG.log(Level.WARNING, call + "\n" + compInfo, ex);
                }
                for (Binding.Adaptor a : this.adaptors) {
                    a.updateBindingConfiguration();
                }
                this.updateSyncConfiguration();
            }
        }

        private void processInfoError(Call call) {
            this.isProperty = false;
            this.bindingInfo = null;
            LOG.log(Level.WARNING, "Couldn't get info for {0}", this.boundAddress);
            for (Binding.Adaptor a : this.adaptors) {
                a.updateBindingConfiguration();
            }
            this.updateSyncConfiguration();
        }

        private void process(Call call) {
            if (call.isReply()) {
                this.processResponse(call);
            } else if (call.isError()) {
                this.processError(call);
            }
        }

        private void processResponse(Call call) {
            if (this.activeCall != null && call.matchID() == this.activeCall.matchID()) {
                if (this.activeAdaptor != null) {
                    this.activeAdaptor.onResponse(call.args());
                    this.activeAdaptor = null;
                }
                if (this.isProperty) {
                    this.values = call.args();
                    for (Binding.Adaptor a : this.adaptors) {
                        a.update();
                    }
                }
                this.activeCall = null;
            } else if (call.matchID() == this.infoMatchID) {
                this.processInfo(call);
            }
        }

        private void processError(Call call) {
            if (this.activeCall != null && call.matchID() == this.activeCall.matchID()) {
                if (this.activeAdaptor != null) {
                    this.activeAdaptor.onError(call.args());
                    this.activeAdaptor = null;
                } else {
                    LOG.log(Level.FINE, "Error on sync call - {0}", call.from());
                }
                this.activeCall = null;
            } else if (call.matchID() == this.infoMatchID) {
                this.processInfoError(call);
            }
        }

        private void processSync() {
            long now = BindingContextControl.this.context.getTime();
            if (this.syncPeriod > 0L) {
                BindingContextControl.this.syncQueue.add(this, now + this.syncPeriod);
            }
            if (this.activeCall != null && (this.activeCall.isReplyRequired() ? now - this.activeCall.time() < INVOKE_TIMEOUT : now - this.activeCall.time() < QUIET_TIMEOUT)) {
                return;
            }
            if (this.isProperty) {
                Call call = Call.create((ControlAddress)this.boundAddress, (ControlAddress)BindingContextControl.this.controlAddress, (long)now);
                BindingContextControl.this.router.route((Packet)call);
                this.activeCall = call;
                this.activeAdaptor = null;
            }
        }

        @Override
        public Optional<ControlInfo> getControlInfo() {
            return Optional.ofNullable(this.bindingInfo);
        }

        @Override
        public List<Value> getValues() {
            return this.values;
        }
    }

    private static class BindingSyncElement
    implements Comparable<BindingSyncElement> {
        private final BindingImpl binding;
        private final long time;

        private BindingSyncElement(BindingImpl binding, long time) {
            this.binding = binding;
            this.time = time;
        }

        @Override
        public int compareTo(BindingSyncElement o) {
            long timeDiff = this.time - o.time;
            if (timeDiff == 0L) {
                return this.hashCode() - o.hashCode();
            }
            return timeDiff < 0L ? -1 : 1;
        }
    }

    private static class BindingSyncQueue {
        private final PriorityQueue<BindingSyncElement> q = new PriorityQueue();
        private long time;

        private BindingSyncQueue(long time) {
            this.time = time;
        }

        private void setTime(long time) {
            this.time = time;
        }

        private void add(BindingImpl binding, long time) {
            this.q.add(new BindingSyncElement(binding, time));
        }

        private BindingImpl poll() {
            if (!this.q.isEmpty() && this.q.peek().time - this.time <= 0L) {
                BindingSyncElement element = this.q.poll();
                return element != null ? element.binding : null;
            }
            return null;
        }
    }
}

