/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.praxislive.core.Call;
import org.praxislive.core.Component;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.Container;
import org.praxislive.core.Control;
import org.praxislive.core.Lookup;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Port;
import org.praxislive.core.Value;
import org.praxislive.core.VetoException;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.ServiceUnavailableException;
import org.praxislive.core.services.Services;

public abstract class AbstractComponent
implements Component {
    private final Map<String, Control> controls = new LinkedHashMap<String, Control>();
    private final Map<String, Port> ports;
    private Container parent;

    protected AbstractComponent() {
        this.controls.put("info", new InfoControl());
        this.ports = new LinkedHashMap<String, Port>();
    }

    public Container getParent() {
        return this.parent;
    }

    public void parentNotify(Container parent) throws VetoException {
        if (parent == null) {
            if (this.parent != null) {
                this.parent = null;
                this.disconnectAll();
            }
        } else {
            if (this.parent != null) {
                throw new VetoException();
            }
            this.parent = parent;
        }
    }

    public void hierarchyChanged() {
    }

    public Control getControl(String id) {
        return this.controls.get(id);
    }

    public Port getPort(String id) {
        return this.ports.get(id);
    }

    protected ComponentAddress getAddress() {
        if (this.parent != null) {
            return this.parent.getAddress((Component)this);
        }
        return null;
    }

    protected Lookup getLookup() {
        return this.parent == null ? Lookup.EMPTY : this.parent.getLookup();
    }

    protected ComponentAddress findService(Class<? extends Service> service) throws ServiceUnavailableException {
        return (ComponentAddress)this.getLookup().find(Services.class).flatMap(sm -> sm.locate(service)).orElseThrow(ServiceUnavailableException::new);
    }

    protected void disconnectAll() {
        this.ports.values().forEach(Port::disconnectAll);
    }

    protected final void registerControl(String id, Control control) {
        if (this.controls.putIfAbsent(Objects.requireNonNull(id), Objects.requireNonNull(control)) != null) {
            throw new IllegalArgumentException();
        }
    }

    protected final void unregisterControl(String id) {
        this.controls.remove(id);
    }

    protected final void registerPort(String id, Port port) {
        if (this.ports.putIfAbsent(Objects.requireNonNull(id), Objects.requireNonNull(port)) != null) {
            throw new IllegalArgumentException();
        }
    }

    protected final void unregisterPort(String id) {
        Port port = this.ports.remove(id);
        if (port != null) {
            port.disconnectAll();
        }
    }

    private class InfoControl
    implements Control {
        private InfoControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isReplyRequired()) {
                router.route((Packet)call.reply((Value)AbstractComponent.this.getInfo()));
            }
        }
    }
}

