/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.praxislive.base.AbstractAsyncControl;
import org.praxislive.base.AbstractComponent;
import org.praxislive.core.Call;
import org.praxislive.core.Component;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.Container;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Lookup;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Port;
import org.praxislive.core.PortConnectionException;
import org.praxislive.core.PortListener;
import org.praxislive.core.Value;
import org.praxislive.core.VetoException;
import org.praxislive.core.services.ComponentFactoryService;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PReference;
import org.praxislive.core.types.PString;

public abstract class AbstractContainer
extends AbstractComponent
implements Container {
    private static final Logger LOG = Logger.getLogger(AbstractContainer.class.getName());
    private final Map<String, Component> childMap = new LinkedHashMap<String, Component>();
    private final Set<PArray> connections = new LinkedHashSet<PArray>();

    protected AbstractContainer() {
        this.registerControl("add-child", new AddChildControl());
        this.registerControl("remove-child", new RemoveChildControl());
        this.registerControl("children", new ChildrenControl());
        this.registerControl("connect", new ConnectControl());
        this.registerControl("disconnect", new DisconnectControl());
        this.registerControl("connections", new ConnectionsControl());
    }

    public Component getChild(String id) {
        return this.childMap.get(id);
    }

    public Stream<String> children() {
        return this.childMap.keySet().stream();
    }

    public ComponentAddress getAddress(Component child) {
        ComponentAddress containerAddress = this.getAddress();
        String childID = this.getChildID(child);
        if (containerAddress == null || childID == null) {
            return null;
        }
        return ComponentAddress.of((ComponentAddress)containerAddress, (String)childID);
    }

    @Override
    public void hierarchyChanged() {
        this.childMap.values().forEach(Component::hierarchyChanged);
    }

    @Override
    public Lookup getLookup() {
        return super.getLookup();
    }

    protected void addChild(String id, Component child) throws VetoException {
        if (this.childMap.putIfAbsent(Objects.requireNonNull(id), Objects.requireNonNull(child)) != null) {
            throw new VetoException("Child ID already in use");
        }
        try {
            this.notifyChild(child);
        }
        catch (VetoException ex) {
            this.childMap.remove(id);
            throw new VetoException();
        }
        child.hierarchyChanged();
    }

    protected void notifyChild(Component child) throws VetoException {
        child.parentNotify((Container)this);
    }

    protected Component removeChild(String id) {
        Component child = this.childMap.remove(id);
        if (child != null) {
            try {
                child.parentNotify(null);
            }
            catch (VetoException ex) {
                LOG.log(Level.SEVERE, "Child throwing Veto on removal", ex);
            }
            child.hierarchyChanged();
        }
        return child;
    }

    protected String getChildID(Component child) {
        for (Map.Entry<String, Component> entry : this.childMap.entrySet()) {
            if (entry.getValue() != child) continue;
            return entry.getKey();
        }
        return null;
    }

    protected void connect(String component1, String port1, String component2, String port2) throws PortConnectionException {
        this.handleConnection(true, PString.of((String)component1), PString.of((String)port1), PString.of((String)component2), PString.of((String)port2));
    }

    protected void disconnect(String component1, String port1, String component2, String port2) {
        try {
            this.handleConnection(false, PString.of((String)component1), PString.of((String)port1), PString.of((String)component2), PString.of((String)port2));
        }
        catch (PortConnectionException ex) {
            Logger.getLogger(AbstractContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void handleConnection(boolean connect, PString c1id, PString p1id, PString c2id, PString p2id) throws PortConnectionException {
        try {
            Component c1 = this.getChild(c1id.toString());
            Port p1 = c1.getPort(p1id.toString());
            Component c2 = this.getChild(c2id.toString());
            Port p2 = c2.getPort(p2id.toString());
            PArray connection = PArray.of((Value[])new Value[]{c1id, p1id, c2id, p2id});
            if (connect) {
                p1.connect(p2);
                this.connections.add(connection);
                ConnectionListener listener = new ConnectionListener(p1, p2, connection);
                p1.addListener((PortListener)listener);
                p2.addListener((PortListener)listener);
            } else {
                p1.disconnect(p2);
                this.connections.remove(connection);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Can't connect ports.", ex);
            throw new PortConnectionException("Can't connect " + c1id + "!" + p1id + " to " + c2id + "!" + p2id);
        }
    }

    public static abstract class Delegate
    extends AbstractContainer {
        @Override
        public abstract Lookup getLookup();

        @Override
        protected abstract ComponentAddress getAddress();

        @Override
        protected abstract void notifyChild(Component var1) throws VetoException;
    }

    private class ConnectionListener
    implements PortListener {
        Port p1;
        Port p2;
        PArray connection;

        private ConnectionListener(Port p1, Port p2, PArray connection) {
            this.p1 = p1;
            this.p2 = p2;
            this.connection = connection;
        }

        public void connectionsChanged(Port source) {
            if (!this.p1.isConnectedTo(this.p2) || !this.p2.isConnectedTo(this.p1)) {
                LOG.log(Level.FINEST, "Removing connection\n{0}", this.connection);
                AbstractContainer.this.connections.remove(this.connection);
                this.p1.removeListener((PortListener)this);
                this.p2.removeListener((PortListener)this);
            }
        }
    }

    protected class ConnectionsControl
    implements Control {
        protected ConnectionsControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            PArray response = PArray.of(AbstractContainer.this.connections);
            router.route((Packet)call.reply((Value)response));
        }
    }

    protected class DisconnectControl
    implements Control {
        protected DisconnectControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            AbstractContainer.this.handleConnection(false, (PString)PString.from((Value)((Value)call.args().get(0))).orElseThrow(), (PString)PString.from((Value)((Value)call.args().get(1))).orElseThrow(), (PString)PString.from((Value)((Value)call.args().get(2))).orElseThrow(), (PString)PString.from((Value)((Value)call.args().get(3))).orElseThrow());
            router.route((Packet)call.reply());
        }
    }

    protected class ConnectControl
    implements Control {
        protected ConnectControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            AbstractContainer.this.handleConnection(true, (PString)PString.from((Value)((Value)call.args().get(0))).orElseThrow(), (PString)PString.from((Value)((Value)call.args().get(1))).orElseThrow(), (PString)PString.from((Value)((Value)call.args().get(2))).orElseThrow(), (PString)PString.from((Value)((Value)call.args().get(3))).orElseThrow());
            router.route((Packet)call.reply());
        }
    }

    protected class ChildrenControl
    implements Control {
        protected ChildrenControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            PArray response = (PArray)AbstractContainer.this.childMap.keySet().stream().map(PString::of).collect(PArray.collector());
            router.route((Packet)call.reply((Value)response));
        }
    }

    protected class RemoveChildControl
    implements Control {
        protected RemoveChildControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            AbstractContainer.this.removeChild(((Value)call.args().get(0)).toString());
            router.route((Packet)call.reply());
        }
    }

    protected class AddChildControl
    extends AbstractAsyncControl {
        protected AddChildControl() {
        }

        @Override
        protected Call processInvoke(Call call) throws Exception {
            List args = call.args();
            if (args.size() < 2) {
                throw new IllegalArgumentException("Invalid arguments");
            }
            if (!ComponentAddress.isValidID((String)((Value)args.get(0)).toString())) {
                throw new IllegalArgumentException("Invalid Component ID");
            }
            ControlAddress to = ControlAddress.of((ComponentAddress)AbstractContainer.this.findService(ComponentFactoryService.class), (String)"new-instance");
            return Call.create((ControlAddress)to, (ControlAddress)call.to(), (long)call.time(), (Value)((Value)args.get(1)));
        }

        @Override
        protected Call processResponse(Call call) throws Exception {
            List args = call.args();
            if (args.size() < 1) {
                throw new IllegalArgumentException("Invalid response");
            }
            Component c = (Component)PReference.from((Value)((Value)args.get(0))).flatMap(r -> r.as(Component.class)).orElseThrow();
            Call active = this.getActiveCall();
            AbstractContainer.this.addChild(((Value)active.args().get(0)).toString(), c);
            return active.reply();
        }
    }
}

