/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.base.DefaultExecutionContext;
import org.praxislive.base.PacketQueue;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ExecutionContext;
import org.praxislive.core.Lookup;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Root;
import org.praxislive.core.RootHub;
import org.praxislive.core.ThreadContext;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.ServiceUnavailableException;
import org.praxislive.core.services.Services;
import org.praxislive.core.types.PError;

public abstract class AbstractRoot
implements Root {
    private static final Logger LOG = Logger.getLogger(AbstractRoot.class.getName());
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final AtomicReference<Delegate> delegate = new AtomicReference();
    private final Queue<Object> queue = new ConcurrentLinkedQueue<Object>();
    private final Queue<Object> pending = new ArrayDeque<Object>();
    private final ReentrantLock lock = new ReentrantLock();
    private final ThreadContext threadContext;
    private volatile long time;
    private Lookup lookup = Lookup.EMPTY;
    private ComponentAddress address;
    private RootHub hub;
    private DefaultExecutionContext context;
    private Controller controller;
    private PacketRouter router;
    private PacketQueue pendingPackets;
    private State cachedState;
    private boolean interrupted;

    protected AbstractRoot() {
        this.threadContext = new ThreadContextImpl();
    }

    public Controller initialize(String id, RootHub hub) {
        if (this.state.compareAndSet(State.NEW, State.INITIALIZING)) {
            if (id == null || hub == null) {
                throw new NullPointerException();
            }
            this.address = ComponentAddress.of((String)("/" + id));
            this.hub = hub;
            this.time = hub.getClock().getTime();
            this.pendingPackets = new PacketQueue(this.time);
            this.context = this.createContext(this.time);
            this.router = this.createRouter();
            this.lookup = Lookup.of((Lookup)hub.getLookup(), (Object[])new Object[]{this.router, this.context, this.threadContext});
            if (this.state.compareAndSet(State.INITIALIZING, State.INITIALIZED)) {
                this.controller = this.createController();
                return this.controller;
            }
        }
        throw new IllegalStateException();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    protected ComponentAddress findService(Class<? extends Service> service) throws ServiceUnavailableException {
        return (ComponentAddress)this.getLookup().find(Services.class).flatMap(sm -> sm.locate(service)).orElseThrow(ServiceUnavailableException::new);
    }

    protected final ComponentAddress getAddress() {
        return this.address;
    }

    protected final RootHub getRootHub() {
        return this.hub;
    }

    protected final PacketRouter getRouter() {
        return this.router;
    }

    protected final ExecutionContext getExecutionContext() {
        return this.context;
    }

    protected State getState() {
        return this.state.get();
    }

    protected Controller createController() {
        return new Controller();
    }

    protected DefaultExecutionContext createContext(long initialTime) {
        return new DefaultExecutionContext(initialTime);
    }

    protected PacketRouter createRouter() {
        return new Router();
    }

    protected void activating() {
    }

    protected void terminating() {
    }

    protected void starting() {
    }

    protected void stopping() {
    }

    protected void update() {
    }

    protected abstract void processCall(Call var1, PacketRouter var2);

    protected final boolean setRunning() {
        if (this.state.compareAndSet(State.ACTIVE_IDLE, State.ACTIVE_RUNNING)) {
            this.starting();
            return true;
        }
        return false;
    }

    protected final boolean setIdle() {
        if (this.state.compareAndSet(State.ACTIVE_RUNNING, State.ACTIVE_IDLE)) {
            this.stopping();
            return true;
        }
        return false;
    }

    protected final void attachDelegate(Delegate delegate) {
        boolean ok = this.delegate.compareAndSet(null, delegate);
        if (!ok) {
            throw new IllegalStateException("Delegate already attached");
        }
        this.interrupt();
    }

    protected final void detachDelegate(Delegate delegate) {
        this.delegate.compareAndSet(delegate, null);
        this.interrupt();
    }

    protected final void interrupt() {
        this.interrupted = true;
    }

    protected final boolean invokeLater(Runnable task) {
        boolean ok = this.queue.add(task);
        if (ok) {
            this.controller.onQueueReceipt();
        }
        return ok;
    }

    private boolean update(long time, boolean poll) {
        this.interrupted = false;
        State currentState = this.state.get();
        if (currentState != State.ACTIVE_IDLE && currentState != State.ACTIVE_RUNNING) {
            if (this.cachedState == State.ACTIVE_RUNNING) {
                this.cachedState = currentState;
                this.stopping();
                this.context.updateState(time, ExecutionContext.State.IDLE);
            }
            return false;
        }
        if (currentState != this.cachedState) {
            this.cachedState = currentState;
            if (this.cachedState == State.ACTIVE_RUNNING) {
                this.context.updateState(time, ExecutionContext.State.ACTIVE);
            } else {
                this.context.updateState(time, ExecutionContext.State.IDLE);
            }
        }
        if (poll) {
            this.pollQueue();
        }
        if (time - this.time < 0L) {
            LOG.log(Level.FINE, () -> "Update time is not monotonic : behind by " + (time - this.time));
            ++this.time;
        } else {
            this.time = time;
        }
        this.context.updateClock(time);
        this.pendingPackets.setTime(time);
        this.update();
        Packet pkt = this.pendingPackets.poll();
        while (pkt != null) {
            this.processPacket(pkt);
            if (this.interrupted) break;
            pkt = this.pendingPackets.poll();
        }
        return true;
    }

    private void pollQueue() {
        if (this.interrupted) {
            return;
        }
        State currentState = this.state.get();
        if (currentState != State.ACTIVE_IDLE && currentState != State.ACTIVE_RUNNING) {
            return;
        }
        long now = this.context.time;
        Object obj = this.queue.poll();
        while (obj != null) {
            this.pending.add(obj);
            obj = this.queue.poll();
        }
        obj = this.pending.poll();
        while (obj != null) {
            if (obj instanceof Packet) {
                Packet pkt = (Packet)obj;
                if (pkt.time() - now > 0L) {
                    this.pendingPackets.add(pkt);
                } else {
                    this.processPacket(pkt);
                }
            } else if (obj instanceof Runnable) {
                try {
                    ((Runnable)obj).run();
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Runnable task error", t);
                }
            } else {
                LOG.log(Level.SEVERE, "Unknown Object in queue : {0}", obj);
            }
            if (this.interrupted) break;
            obj = this.pending.poll();
        }
    }

    private void shutdownQueues() {
        Object obj = this.queue.poll();
        while (obj != null) {
            this.pending.add(obj);
            obj = this.queue.poll();
        }
        this.pendingPackets.drainTo(this.pending);
        obj = this.pending.poll();
        while (obj != null) {
            if (obj instanceof Call) {
                this.router.route((Packet)((Call)obj).error(PError.of((String)"Root terminated")));
            } else if (obj instanceof Runnable) {
                try {
                    ((Runnable)obj).run();
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Runnable task error", t);
                }
            }
            obj = this.pending.poll();
        }
    }

    private void processPacket(Packet packet) {
        if (packet instanceof Call) {
            Call call = (Call)packet;
            try {
                this.processCall(call, this.router);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Uncaught exception processing call", t);
                if (call.isReplyRequired()) {
                    Exception ex = t instanceof Exception ? (Exception)t : new IllegalStateException(t);
                    this.router.route((Packet)((Call)packet).error(PError.of((Exception)ex)));
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected static DelegateConfiguration delegateConfig() {
        return new DelegateConfiguration();
    }

    protected static final class DelegateConfiguration {
        private boolean backgroundPoll = false;
        private long forceUpdateNanos = 0L;

        private DelegateConfiguration() {
        }

        public DelegateConfiguration pollInBackground() {
            this.backgroundPoll = true;
            return this;
        }

        public DelegateConfiguration forceUpdateAfter(long time, TimeUnit unit) {
            long ns = unit.toNanos(time);
            if (ns < 1L) {
                throw new IllegalArgumentException();
            }
            this.forceUpdateNanos = ns;
            return this;
        }
    }

    protected abstract class Delegate {
        private final ReentrantLock pollLock = new ReentrantLock();
        private final Condition pollCondition = this.pollLock.newCondition();
        private final boolean backgroundPoll;
        private final long forceUpdateAfterNS;
        private final long maxDriftNS;
        private Thread delegateThread;

        protected Delegate() {
            this(null);
        }

        protected Delegate(DelegateConfiguration config) {
            this.backgroundPoll = config == null ? false : config.backgroundPoll;
            this.forceUpdateAfterNS = config == null ? 0L : config.forceUpdateNanos;
            this.maxDriftNS = TimeUnit.SECONDS.toNanos(1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean doUpdate(long time) {
            AbstractRoot.this.lock.lock();
            try {
                if (AbstractRoot.this.delegate.get() != this) {
                    LOG.info("Delegate invalid");
                    boolean bl = false;
                    return bl;
                }
                this.delegateThread = Thread.currentThread();
                boolean bl = AbstractRoot.this.update(this.correctUpdateTime(time), true);
                return bl;
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Uncaught error", t);
                boolean bl = true;
                return bl;
            }
            finally {
                AbstractRoot.this.lock.unlock();
            }
        }

        protected final void doPollQueue() {
            if (AbstractRoot.this.lock.tryLock()) {
                try {
                    if (AbstractRoot.this.delegate.get() == this) {
                        this.delegateThread = Thread.currentThread();
                        AbstractRoot.this.pollQueue();
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Uncaught error", t);
                }
                finally {
                    AbstractRoot.this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void doTimedPoll(long time, TimeUnit unit) throws InterruptedException {
            if (time > 0L) {
                this.pollLock.lockInterruptibly();
                try {
                    if (AbstractRoot.this.queue.isEmpty()) {
                        this.pollCondition.await(time, unit);
                    }
                }
                finally {
                    this.pollLock.unlock();
                }
            }
            this.doPollQueue();
        }

        protected final ThreadFactory getThreadFactory() {
            return AbstractRoot.this.controller.threadFactory;
        }

        protected void onQueueReceipt() {
            if (this.pollLock.tryLock()) {
                try {
                    this.pollCondition.signal();
                }
                finally {
                    this.pollLock.unlock();
                }
            }
        }

        protected boolean isRootThread() {
            return Thread.currentThread() == this.delegateThread;
        }

        private boolean clockCheck() {
            long delta = AbstractRoot.this.hub.getClock().getTime() - AbstractRoot.this.time;
            if (this.forceUpdateAfterNS > 0L && delta > this.forceUpdateAfterNS) {
                return true;
            }
            if (Math.abs(delta) > 10000000000L) {
                LOG.log(Level.SEVERE, "Delegate not updating time");
            }
            return false;
        }

        private long correctUpdateTime(long updateTime) {
            long hubTime = AbstractRoot.this.hub.getClock().getTime();
            long rootTime = AbstractRoot.this.time;
            long correctedTime = updateTime;
            long delta = updateTime - hubTime;
            if (delta < -this.maxDriftNS) {
                correctedTime = hubTime - this.maxDriftNS;
            } else if (delta > this.maxDriftNS) {
                correctedTime = hubTime + this.maxDriftNS;
            }
            delta = updateTime - rootTime;
            if (delta < 0L) {
                correctedTime = rootTime + 1L;
            }
            return correctedTime;
        }
    }

    protected class Controller
    implements Root.Controller {
        private final AtomicBoolean updateQueued = new AtomicBoolean();
        private ScheduledExecutorService exec;
        private ScheduledFuture<?> updateTask;
        private ThreadFactory threadFactory;
        private boolean ownsScheduler;

        protected Controller() {
        }

        public boolean submitPacket(Packet packet) {
            boolean ok = AbstractRoot.this.queue.offer(packet);
            if (ok) {
                this.onQueueReceipt();
            }
            return ok;
        }

        public void start(ThreadFactory threadFactory) {
            if (AbstractRoot.this.state.compareAndSet(State.INITIALIZED, State.ACTIVE_IDLE)) {
                this.threadFactory = threadFactory;
                this.exec = AbstractRoot.this.hub.getLookup().find(ScheduledExecutorService.class).orElse(null);
                if (this.exec == null) {
                    this.exec = Executors.newScheduledThreadPool(1, threadFactory);
                    this.ownsScheduler = true;
                }
            } else {
                throw new IllegalStateException();
            }
            this.exec.execute(this::doActivate);
        }

        public void shutdown() {
            AbstractRoot.this.state.updateAndGet(s -> s == State.TERMINATED ? State.TERMINATED : State.TERMINATING);
        }

        protected void onQueueReceipt() {
            Delegate del = AbstractRoot.this.delegate.get();
            if (del != null && !del.backgroundPoll) {
                del.onQueueReceipt();
            } else if (this.updateQueued.compareAndSet(false, true)) {
                this.exec.execute(this::doPoll);
            }
        }

        private void doActivate() {
            try {
                AbstractRoot.this.activating();
                this.updateTask = this.exec.scheduleAtFixedRate(this::doUpdate, 0L, 10L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Uncaught error in activation", t);
                this.doTerminate();
            }
        }

        private void doUpdate() {
            Delegate del = AbstractRoot.this.delegate.get();
            if (del != null && !del.clockCheck()) {
                return;
            }
            AbstractRoot.this.lock.lock();
            try {
                if (!AbstractRoot.this.update(AbstractRoot.this.hub.getClock().getTime(), true)) {
                    this.updateTask.cancel(false);
                    this.doTerminate();
                }
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Uncaught error", t);
            }
            finally {
                AbstractRoot.this.lock.unlock();
            }
        }

        private void doPoll() {
            this.updateQueued.set(false);
            Delegate del = AbstractRoot.this.delegate.get();
            if ((del == null || del.backgroundPoll) && AbstractRoot.this.lock.tryLock()) {
                try {
                    AbstractRoot.this.pollQueue();
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Uncaught error", t);
                }
                finally {
                    AbstractRoot.this.lock.unlock();
                }
            }
        }

        private void doTerminate() {
            State s = AbstractRoot.this.state.get();
            while (s != State.TERMINATED) {
                if (AbstractRoot.this.state.compareAndSet(s, State.TERMINATED)) {
                    AbstractRoot.this.lock.lock();
                    try {
                        AbstractRoot.this.shutdownQueues();
                        try {
                            AbstractRoot.this.terminating();
                        }
                        catch (Throwable t) {
                            LOG.log(Level.SEVERE, "Uncaught error in termination", t);
                        }
                        AbstractRoot.this.context.updateState(AbstractRoot.this.hub.getClock().getTime(), ExecutionContext.State.TERMINATED);
                        if (!this.ownsScheduler) continue;
                        this.exec.shutdown();
                        continue;
                    }
                    finally {
                        AbstractRoot.this.lock.unlock();
                        continue;
                    }
                }
                s = AbstractRoot.this.state.get();
            }
        }
    }

    private class ThreadContextImpl
    implements ThreadContext {
        private ThreadContextImpl() {
        }

        public void invokeLater(Runnable task) {
            AbstractRoot.this.invokeLater(task);
        }

        public boolean isInUpdate() {
            return AbstractRoot.this.lock.isHeldByCurrentThread();
        }

        public boolean isRootThread() {
            if (this.isInUpdate()) {
                return true;
            }
            Delegate del = AbstractRoot.this.delegate.get();
            if (del != null) {
                return del.isRootThread();
            }
            return false;
        }

        public boolean supportsDirectInvoke() {
            return true;
        }

        public <T> T invoke(Callable<T> task) throws Exception {
            AbstractRoot.this.lock.lock();
            try {
                T t = task.call();
                return t;
            }
            finally {
                AbstractRoot.this.lock.unlock();
            }
        }
    }

    private class Router
    implements PacketRouter {
        private Router() {
        }

        public void route(Packet packet) {
            Call call;
            boolean success;
            try {
                success = AbstractRoot.this.hub.dispatch(packet);
            }
            catch (Exception ex) {
                success = false;
            }
            if (!success && packet instanceof Call && (call = (Call)packet).isReplyRequired()) {
                this.route((Packet)call.error(List.of()));
            }
        }
    }

    protected static enum State {
        NEW,
        INITIALIZING,
        INITIALIZED,
        ACTIVE_IDLE,
        ACTIVE_RUNNING,
        TERMINATING,
        TERMINATED;

    }
}

