/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.praxislive.core.ExecutionContext;

public class DefaultExecutionContext
implements ExecutionContext {
    private final List<ExecutionContext.StateListener> stateListeners = new CopyOnWriteArrayList<ExecutionContext.StateListener>();
    private final List<ExecutionContext.ClockListener> clockListeners = new CopyOnWriteArrayList<ExecutionContext.ClockListener>();
    private ExecutionContext.State state = ExecutionContext.State.NEW;
    long time;
    private long startTime;

    public DefaultExecutionContext(long time) {
        this.time = this.startTime = time;
    }

    public void addStateListener(ExecutionContext.StateListener listener) {
        this.stateListeners.add(Objects.requireNonNull(listener));
    }

    public void removeStateListener(ExecutionContext.StateListener listener) {
        this.stateListeners.remove(listener);
    }

    public void addClockListener(ExecutionContext.ClockListener listener) {
        this.clockListeners.add(Objects.requireNonNull(listener));
    }

    public void removeClockListener(ExecutionContext.ClockListener listener) {
        this.clockListeners.remove(listener);
    }

    protected void updateState(long time, ExecutionContext.State state) {
        this.time = time;
        switch (state) {
            case ACTIVE: {
                if (this.state != ExecutionContext.State.ACTIVE) {
                    this.startTime = time;
                }
            }
            case IDLE: {
                if (this.state == ExecutionContext.State.TERMINATED) {
                    throw new IllegalStateException("Execution Context terminated");
                }
            }
            case TERMINATED: {
                if (this.state == state) break;
                this.state = state;
                this.fireStateListeners();
                break;
            }
            case NEW: {
                if (this.state == ExecutionContext.State.NEW) break;
                throw new IllegalStateException("Can't make Execution Context NEW again.");
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public ExecutionContext.State getState() {
        return this.state;
    }

    protected void updateClock(long time) {
        this.time = time;
        if (this.state == ExecutionContext.State.ACTIVE) {
            this.fireClockListeners();
        }
    }

    public long getTime() {
        return this.time;
    }

    public long getStartTime() {
        return this.startTime;
    }

    private void fireStateListeners() {
        this.stateListeners.forEach(l -> l.stateChanged((ExecutionContext)this));
    }

    private void fireClockListeners() {
        this.clockListeners.forEach(l -> l.tick((ExecutionContext)this));
    }
}

