/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base.components;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.praxislive.base.AbstractContainer;
import org.praxislive.base.AbstractProperty;
import org.praxislive.core.Component;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ControlPort;
import org.praxislive.core.Info;
import org.praxislive.core.Port;
import org.praxislive.core.PortAddress;
import org.praxislive.core.PortConnectionException;
import org.praxislive.core.PortInfo;
import org.praxislive.core.PortListener;
import org.praxislive.core.Value;
import org.praxislive.core.VetoException;
import org.praxislive.core.protocols.ComponentProtocol;
import org.praxislive.core.protocols.ContainerProtocol;
import org.praxislive.core.types.PMap;

public final class UserContainer
extends AbstractContainer {
    private static final ComponentInfo BASE_INFO = Info.component(cmp -> cmp.merge(ComponentProtocol.API_INFO).merge(ContainerProtocol.API_INFO).control("ports", c -> c.property().input(PMap.class).defaultValue((Value)PMap.EMPTY)).property("dynamic", (Object)true));
    private static final PortInfo FALLBACK_PORT_INFO = PortInfo.create(ControlPort.class, (PortInfo.Direction)PortInfo.Direction.BIDI, (PMap)PMap.EMPTY);
    private final Map<String, PortProxy> proxies = new LinkedHashMap<String, PortProxy>();
    private ComponentInfo info;

    public UserContainer() {
        this.registerControl("ports", new PortsBinding());
    }

    @Override
    public Port getPort(String id) {
        Port port = super.getPort(id);
        if (port != null) {
            return port;
        }
        PortProxy proxy = this.proxies.get(id);
        if (proxy != null) {
            return proxy.unproxy();
        }
        return null;
    }

    @Override
    protected void addChild(String id, Component child) throws VetoException {
        super.addChild(id, child);
        this.info = null;
    }

    @Override
    protected Component removeChild(String id) {
        this.info = null;
        return super.removeChild(id);
    }

    public ComponentInfo getInfo() {
        if (this.info == null) {
            if (this.proxies.isEmpty()) {
                this.info = BASE_INFO;
            } else {
                Info.ComponentInfoBuilder builder = Info.component().merge(BASE_INFO);
                boolean fallback = false;
                for (PortProxy proxy : this.proxies.values()) {
                    PortInfo portInfo = proxy.getInfo();
                    if (portInfo == FALLBACK_PORT_INFO && this.getChild(proxy.childID) != null) {
                        fallback = true;
                    }
                    builder.port(proxy.id, portInfo);
                }
                if (fallback) {
                    return builder.build();
                }
                this.info = builder.build();
            }
        }
        return this.info;
    }

    private class PortProxy
    implements Port {
        private final String id;
        private final String childID;
        private final String portID;

        PortProxy(String id, String childID, String portID) {
            this.id = id;
            this.childID = childID;
            this.portID = portID;
        }

        private PortInfo getInfo() {
            PortInfo portInfo;
            ComponentInfo info;
            Component child = UserContainer.this.getChild(this.childID);
            if (child != null && (info = child.getInfo()) != null && (portInfo = info.portInfo(this.portID)) != null) {
                return portInfo;
            }
            return FALLBACK_PORT_INFO;
        }

        private Port unproxy() {
            Port port;
            Component child = UserContainer.this.getChild(this.childID);
            if (child != null && (port = child.getPort(this.portID)) != null) {
                return port;
            }
            return this;
        }

        public void connect(Port port) throws PortConnectionException {
            throw new PortConnectionException();
        }

        public void disconnect(Port port) {
        }

        public void disconnectAll() {
        }

        public List<? extends Port> connections() {
            return List.of();
        }

        public void addListener(PortListener listener) {
        }

        public void removeListener(PortListener listener) {
        }
    }

    private class PortsBinding
    extends AbstractProperty {
        private PMap ports = PMap.EMPTY;

        private PortsBinding() {
        }

        @Override
        protected void set(long time, Value arg) throws Exception {
            PMap newPorts = (PMap)PMap.from((Value)arg).orElseThrow(IllegalArgumentException::new);
            if (this.ports.equals((Object)newPorts)) {
                return;
            }
            ArrayList<PortProxy> lst = new ArrayList<PortProxy>();
            List newPortNames = newPorts.keys();
            for (String key : newPorts.keys()) {
                if (!PortAddress.isValidID((String)key)) {
                    throw new IllegalArgumentException(key + " : is not a valid port ID");
                }
                String s = newPorts.get(key).toString();
                String[] parts = s.split("!");
                if (parts.length != 2) {
                    throw new IllegalArgumentException(s + " : is not a valid relative port");
                }
                String child = parts[0];
                String port = parts[1];
                if (!ComponentAddress.isValidID((String)child)) {
                    throw new IllegalArgumentException(child + " : is not a valid component ID");
                }
                if (!PortAddress.isValidID((String)port)) {
                    throw new IllegalArgumentException(key + " : is not a valid port ID");
                }
                lst.add(new PortProxy(key, child, port));
            }
            for (String id : this.ports.keys()) {
                if (newPortNames.contains(id)) continue;
                Port p = UserContainer.this.getPort(id);
                p.disconnectAll();
            }
            UserContainer.this.proxies.clear();
            for (PortProxy p : lst) {
                UserContainer.this.proxies.put(p.id, p);
            }
            this.ports = newPorts;
            UserContainer.this.info = null;
        }

        @Override
        protected Value get() {
            return this.ports;
        }
    }
}

