/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.LinkedList;
import java.util.Queue;
import org.praxislive.core.Call;
import org.praxislive.core.Control;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.types.PError;

public abstract class AbstractAsyncControl
implements Control {
    private static final System.Logger LOG = System.getLogger(AbstractAsyncControl.class.getName());
    private final Queue<Call> callQueue = new LinkedList<Call>();
    private Call pending;

    protected AbstractAsyncControl() {
    }

    public void call(Call call, PacketRouter router) throws Exception {
        if (call.isRequest()) {
            this.processInvoke(call, router);
        } else {
            this.processResponse(call, router);
        }
    }

    protected Call getActiveCall() {
        return this.callQueue.peek();
    }

    protected abstract Call processInvoke(Call var1) throws Exception;

    protected abstract Call processResponse(Call var1) throws Exception;

    protected Call processError(Call call) throws Exception {
        return this.getActiveCall().error(call.args());
    }

    private void processInvoke(Call call, PacketRouter router) {
        if (this.callQueue.isEmpty()) {
            this.callQueue.add(call);
            this.doInvokeLoop(router);
        } else {
            this.callQueue.add(call);
        }
    }

    private void processResponse(Call call, PacketRouter router) {
        block5: {
            if (this.pending == null || this.pending.matchID() != call.matchID()) {
                LOG.log(System.Logger.Level.WARNING, "Unexpected call received by processResponse(call, router)");
                return;
            }
            this.pending = null;
            try {
                Call ret = call.isError() ? this.processError(call) : this.processResponse(call);
                if (ret.isRequest()) {
                    this.pending = ret;
                    router.route((Packet)ret);
                    return;
                }
                Call active = this.callQueue.peek();
                if (active.matchID() != ret.matchID()) {
                    throw new IllegalStateException();
                }
                this.callQueue.poll();
                router.route((Packet)ret);
            }
            catch (Exception ex) {
                Call active = this.callQueue.poll();
                if (active == null) break block5;
                router.route((Packet)active.error(PError.of((Exception)ex)));
            }
        }
        this.doInvokeLoop(router);
    }

    private void doInvokeLoop(PacketRouter router) {
        while (!this.callQueue.isEmpty()) {
            Call call = this.callQueue.peek();
            try {
                Call ret = this.processInvoke(call);
                if (ret.isRequest()) {
                    if (!ret.isReplyRequired()) {
                        throw new IllegalStateException("processInvoke(call) returned illegal quiet call");
                    }
                    this.pending = ret;
                    router.route((Packet)ret);
                    return;
                }
                if (ret.matchID() != call.matchID()) {
                    throw new IllegalStateException("processInvoke(call) returned non-matching response call");
                }
                this.callQueue.poll();
                router.route((Packet)ret);
            }
            catch (Exception ex) {
                LOG.log(System.Logger.Level.DEBUG, "Exception thrown processing call", (Throwable)ex);
                this.callQueue.poll();
                router.route((Packet)call.error(PError.of((Exception)ex)));
            }
        }
    }
}

