/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.praxislive.core.Component;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Lookup;
import org.praxislive.core.Root;
import org.praxislive.core.services.ComponentFactory;
import org.praxislive.core.services.ComponentInstantiationException;

public class AbstractComponentFactory
implements ComponentFactory {
    private final Map<ComponentType, Lookup> componentMap = new LinkedHashMap<ComponentType, Lookup>();
    private final Map<ComponentType, Lookup> rootMap = new LinkedHashMap<ComponentType, Lookup>(1);

    protected AbstractComponentFactory() {
    }

    public final Stream<ComponentType> componentTypes() {
        return this.componentMap.keySet().stream();
    }

    public final Stream<ComponentType> rootTypes() {
        return this.rootMap.keySet().stream();
    }

    public final Component createComponent(ComponentType type) throws ComponentInstantiationException {
        Lookup data = this.componentMap.get(type);
        if (data == null) {
            throw new IllegalArgumentException();
        }
        try {
            Class cl = data.findAll(Class.class).filter(Component.class::isAssignableFrom).map(cls -> cls.asSubclass(Component.class)).findFirst().orElseThrow();
            return (Component)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new ComponentInstantiationException((Throwable)ex);
        }
    }

    public final Root createRoot(ComponentType type) throws ComponentInstantiationException {
        Lookup data = this.rootMap.get(type);
        if (data == null) {
            throw new IllegalArgumentException();
        }
        try {
            Class cl = data.findAll(Class.class).filter(Root.class::isAssignableFrom).map(cls -> cls.asSubclass(Root.class)).findFirst().orElseThrow();
            return (Root)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new ComponentInstantiationException((Throwable)ex);
        }
    }

    public final Lookup componentData(ComponentType type) {
        return this.componentMap.get(type);
    }

    public final Lookup rootData(ComponentType type) {
        return this.rootMap.get(type);
    }

    protected void add(String type, Class<? extends Component> cls) {
        this.add(type, AbstractComponentFactory.data(cls));
    }

    protected void add(String type, Data<? extends Component> info) {
        this.componentMap.put(ComponentType.of((String)type), info.toLookup());
    }

    protected void addRoot(String type, Class<? extends Root> cls) {
        this.addRoot(type, AbstractComponentFactory.data(cls));
    }

    protected void addRoot(String type, Data<? extends Root> info) {
        this.rootMap.put(ComponentType.of((String)type), info.toLookup());
    }

    public static <T> Data<T> data(Class<T> cls) {
        return new Data<T>(cls);
    }

    public static class Data<T> {
        private final List<Object> lookupList = new ArrayList<Object>();

        private Data(Class<T> cls) {
            this.lookupList.add(cls);
        }

        public Data<T> deprecated() {
            this.lookupList.add(new ComponentFactory.Deprecated());
            return this;
        }

        public Data<T> replacement(String type) {
            this.lookupList.add(new ComponentFactory.Deprecated(ComponentType.of((String)type)));
            return this;
        }

        public Data<T> add(Object obj) {
            this.lookupList.add(obj);
            return this;
        }

        private Lookup toLookup() {
            return Lookup.of((Object[])this.lookupList.toArray());
        }
    }
}

