/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.praxislive.base.AbstractAsyncControl;
import org.praxislive.base.AbstractComponent;
import org.praxislive.core.Call;
import org.praxislive.core.Component;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Connection;
import org.praxislive.core.Container;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Lookup;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Port;
import org.praxislive.core.PortConnectionException;
import org.praxislive.core.PortListener;
import org.praxislive.core.TreeWriter;
import org.praxislive.core.Value;
import org.praxislive.core.VetoException;
import org.praxislive.core.protocols.SupportedTypes;
import org.praxislive.core.services.ComponentFactoryService;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PReference;
import org.praxislive.core.types.PString;

public abstract class AbstractContainer
extends AbstractComponent
implements Container {
    private static final System.Logger LOG = System.getLogger(AbstractContainer.class.getName());
    private final Map<String, Component> childMap = new LinkedHashMap<String, Component>();
    private final Map<Component, ComponentType> childTypeMap = new HashMap<Component, ComponentType>();
    private final Set<Connection> connections = new LinkedHashSet<Connection>();

    protected AbstractContainer() {
        this.registerControl("add-child", new AddChildControl());
        this.registerControl("remove-child", new RemoveChildControl());
        this.registerControl("children", new ChildrenControl());
        this.registerControl("connect", new ConnectControl());
        this.registerControl("disconnect", new DisconnectControl());
        this.registerControl("connections", new ConnectionsControl());
        this.registerControl("supported-types", (call, router) -> router.route((Packet)call.reply((Value)this.getLookup().find(SupportedTypes.class).map(types -> types.query().typesAsArray()).orElse(PArray.EMPTY))));
    }

    public Component getChild(String id) {
        return this.childMap.get(id);
    }

    public Stream<String> children() {
        return this.childMap.keySet().stream();
    }

    public ComponentAddress getAddress(Component child) {
        ComponentAddress containerAddress = this.getAddress();
        String childID = this.getChildID(child);
        if (containerAddress == null || childID == null) {
            return null;
        }
        return ComponentAddress.of((ComponentAddress)containerAddress, (String)childID);
    }

    public ComponentType getType(Component child) {
        return this.childTypeMap.computeIfAbsent(child, x$0 -> super.getType(x$0));
    }

    @Override
    public void hierarchyChanged() {
        this.childMap.values().forEach(Component::hierarchyChanged);
    }

    @Override
    public Lookup getLookup() {
        return super.getLookup();
    }

    @Override
    public void write(TreeWriter writer) {
        super.write(writer);
        this.writeChildren(writer);
        this.writeConnections(writer);
    }

    protected final void writeChildren(TreeWriter writer) {
        this.childMap.forEach((id, child) -> writer.writeChild(id, arg_0 -> ((Component)child).write(arg_0)));
    }

    protected final void writeConnections(TreeWriter writer) {
        this.connections.forEach(arg_0 -> ((TreeWriter)writer).writeConnection(arg_0));
    }

    protected void addChild(String id, Component child) throws VetoException {
        if (this.childMap.putIfAbsent(Objects.requireNonNull(id), Objects.requireNonNull(child)) != null) {
            throw new VetoException("Child ID already in use");
        }
        try {
            this.notifyChild(child);
        }
        catch (VetoException ex) {
            this.childMap.remove(id);
            throw new VetoException();
        }
        child.hierarchyChanged();
    }

    protected void recordChildType(Component child, ComponentType type) {
        this.childTypeMap.put(Objects.requireNonNull(child), Objects.requireNonNull(type));
    }

    protected void notifyChild(Component child) throws VetoException {
        child.parentNotify((Container)this);
    }

    protected Component removeChild(String id) {
        Component child = this.childMap.remove(id);
        if (child != null) {
            try {
                child.parentNotify(null);
            }
            catch (VetoException ex) {
                LOG.log(System.Logger.Level.ERROR, "Child throwing Veto on removal", (Throwable)ex);
            }
            child.hierarchyChanged();
            this.childTypeMap.remove(child);
        }
        return child;
    }

    protected String getChildID(Component child) {
        for (Map.Entry<String, Component> entry : this.childMap.entrySet()) {
            if (entry.getValue() != child) continue;
            return entry.getKey();
        }
        return null;
    }

    protected void connect(String component1, String port1, String component2, String port2) throws PortConnectionException {
        this.handleConnection(true, component1, port1, component2, port2);
    }

    protected void disconnect(String component1, String port1, String component2, String port2) {
        try {
            this.handleConnection(false, component1, port1, component2, port2);
        }
        catch (PortConnectionException ex) {
            LOG.log(System.Logger.Level.ERROR, "", (Throwable)ex);
        }
    }

    private void handleConnection(boolean connect, String component1, String port1, String component2, String port2) throws PortConnectionException {
        try {
            Component c1 = this.getChild(component1);
            Port p1 = c1.getPort(port1);
            Component c2 = this.getChild(component2);
            Port p2 = c2.getPort(port2);
            Connection connection = Connection.of((String)component1, (String)port1, (String)component2, (String)port2);
            if (connect) {
                p1.connect(p2);
                this.connections.add(connection);
                ConnectionListener listener = new ConnectionListener(p1, p2, connection);
                p1.addListener((PortListener)listener);
                p2.addListener((PortListener)listener);
            } else {
                p1.disconnect(p2);
                this.connections.remove(connection);
            }
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.DEBUG, "Can't connect ports.", (Throwable)ex);
            throw new PortConnectionException("Can't connect " + component1 + "!" + port1 + " to " + component2 + "!" + port2);
        }
    }

    protected class AddChildControl
    extends AbstractAsyncControl {
        protected AddChildControl() {
        }

        @Override
        protected Call processInvoke(Call call) throws Exception {
            List args = call.args();
            if (args.size() < 2) {
                throw new IllegalArgumentException("Invalid arguments");
            }
            if (!ComponentAddress.isValidID((String)((Value)args.get(0)).toString())) {
                throw new IllegalArgumentException("Invalid Component ID");
            }
            ControlAddress to = ControlAddress.of((ComponentAddress)AbstractContainer.this.findService(ComponentFactoryService.class), (String)"new-instance");
            return Call.create((ControlAddress)to, (ControlAddress)call.to(), (long)call.time(), (Value)((Value)args.get(1)));
        }

        @Override
        protected Call processResponse(Call call) throws Exception {
            List args = call.args();
            if (args.size() < 1) {
                throw new IllegalArgumentException("Invalid response");
            }
            Component child = (Component)PReference.from((Value)((Value)args.get(0))).flatMap(r -> r.as(Component.class)).orElseThrow();
            Call active = this.getActiveCall();
            String id = ((Value)active.args().get(0)).toString();
            ComponentType type = ComponentType.from((Value)((Value)active.args().get(1))).orElse(null);
            AbstractContainer.this.addChild(id, child);
            AbstractContainer.this.recordChildType(child, type);
            return active.reply();
        }
    }

    protected class RemoveChildControl
    implements Control {
        protected RemoveChildControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            AbstractContainer.this.removeChild(((Value)call.args().get(0)).toString());
            router.route((Packet)call.reply());
        }
    }

    protected class ChildrenControl
    implements Control {
        protected ChildrenControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            PArray response = (PArray)AbstractContainer.this.childMap.keySet().stream().map(PString::of).collect(PArray.collector());
            router.route((Packet)call.reply((Value)response));
        }
    }

    protected class ConnectControl
    implements Control {
        protected ConnectControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            AbstractContainer.this.handleConnection(true, ((Value)call.args().get(0)).toString(), ((Value)call.args().get(1)).toString(), ((Value)call.args().get(2)).toString(), ((Value)call.args().get(3)).toString());
            router.route((Packet)call.reply());
        }
    }

    protected class DisconnectControl
    implements Control {
        protected DisconnectControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            AbstractContainer.this.handleConnection(false, ((Value)call.args().get(0)).toString(), ((Value)call.args().get(1)).toString(), ((Value)call.args().get(2)).toString(), ((Value)call.args().get(3)).toString());
            router.route((Packet)call.reply());
        }
    }

    protected class ConnectionsControl
    implements Control {
        protected ConnectionsControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            PArray response = PArray.of(AbstractContainer.this.connections);
            router.route((Packet)call.reply((Value)response));
        }
    }

    private class ConnectionListener
    implements PortListener {
        Port p1;
        Port p2;
        Connection connection;

        private ConnectionListener(Port p1, Port p2, Connection connection) {
            this.p1 = p1;
            this.p2 = p2;
            this.connection = connection;
        }

        public void connectionsChanged(Port source) {
            if (!this.p1.isConnectedTo(this.p2) || !this.p2.isConnectedTo(this.p1)) {
                LOG.log(System.Logger.Level.TRACE, "Removing connection\n{0}", this.connection);
                AbstractContainer.this.connections.remove(this.connection);
                this.p1.removeListener((PortListener)this);
                this.p2.removeListener((PortListener)this);
            }
        }
    }

    public static abstract class Delegate
    extends AbstractContainer {
        @Override
        public abstract Lookup getLookup();

        @Override
        protected abstract ComponentAddress getAddress();

        @Override
        protected abstract void notifyChild(Component var1) throws VetoException;
    }
}

