/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Connection;
import org.praxislive.core.TreeWriter;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PString;

public final class MapTreeWriter
implements TreeWriter {
    private static final String ANNOTATION_PREFIX = "%";
    private static final String CHILD_PREFIX = "@";
    private static final String TYPE_KEY = "%type";
    private static final String INFO_KEY = "%info";
    private static final String CONNECTIONS_KEY = "%connections";
    private final Map<String, Value> map = new LinkedHashMap<String, Value>();
    private MapTreeWriter childWriter;
    private Set<Connection> connections;

    public MapTreeWriter() {
        this.presetKeys();
    }

    public MapTreeWriter writeAnnotation(String key, String value) {
        this.map.putIfAbsent(ANNOTATION_PREFIX + key, (Value)PString.of((String)value));
        return this;
    }

    public MapTreeWriter writeChild(String id, Consumer<TreeWriter> processor) {
        if (this.childWriter == null) {
            this.childWriter = new MapTreeWriter();
        }
        processor.accept(this.childWriter);
        this.map.put(CHILD_PREFIX + id, (Value)this.childWriter.build());
        this.childWriter.clear();
        return this;
    }

    public MapTreeWriter writeConnection(Connection connection) {
        if (this.connections == null) {
            this.connections = new LinkedHashSet<Connection>();
        }
        this.connections.add(Objects.requireNonNull(connection));
        return this;
    }

    public MapTreeWriter writeInfo(ComponentInfo info) {
        this.map.put(INFO_KEY, (Value)info);
        return this;
    }

    public MapTreeWriter writeProperty(String id, Value value) {
        this.map.put(id, value);
        return this;
    }

    public MapTreeWriter writeType(ComponentType type) {
        this.map.put(TYPE_KEY, (Value)type);
        return this;
    }

    public PMap build() {
        this.map.computeIfPresent(TYPE_KEY, (k, v) -> v.isEmpty() ? null : v);
        this.map.computeIfPresent(INFO_KEY, (k, v) -> v.isEmpty() ? null : v);
        if (this.connections != null) {
            this.map.put(CONNECTIONS_KEY, (Value)this.connections.stream().map(PArray.ArrayBasedValue::dataArray).collect(PArray.collector()));
        }
        return PMap.ofMap(this.map);
    }

    public MapTreeWriter clear() {
        this.map.clear();
        if (this.childWriter != null) {
            this.childWriter.clear();
        }
        if (this.connections != null) {
            this.connections.clear();
        }
        this.presetKeys();
        return this;
    }

    private void presetKeys() {
        this.map.put(TYPE_KEY, (Value)PString.EMPTY);
        this.map.put(INFO_KEY, (Value)PString.EMPTY);
    }
}

