/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.praxislive.core.ComponentRegistry;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Container;
import org.praxislive.core.protocols.SupportedTypes;

public class FilteredTypes
implements SupportedTypes {
    private final Container context;
    private final Predicate<ComponentType> filter;
    private final Supplier<List<ComponentType>> additional;
    private final boolean includeParentAdditional;
    private SupportedTypes.Result result;
    private List<ComponentType> addedTypes;
    private SupportedTypes delegate;
    private SupportedTypes.Result delegateResult;

    private FilteredTypes(Container context, Predicate<ComponentType> filter, Supplier<List<ComponentType>> additional, boolean includeParentAdditional) {
        this.context = context;
        this.filter = filter;
        this.additional = additional;
        this.includeParentAdditional = includeParentAdditional;
    }

    public SupportedTypes.Result query() {
        if (this.result == null) {
            this.delegate = Optional.ofNullable(this.context.getParent()).flatMap(p -> p.getLookup().find(SupportedTypes.class)).filter(d -> d != this).orElseGet(() -> new BaseDelegate(this));
            this.delegateResult = this.delegate.query();
            this.result = this.calculateResult(this.delegate, this.delegateResult);
        } else {
            SupportedTypes.Result delRes = this.delegate.query();
            if (delRes != this.delegateResult) {
                this.delegateResult = delRes;
                this.result = this.calculateResult(this.delegate, this.delegateResult);
            }
        }
        return this.result;
    }

    public void reset() {
        this.result = null;
        this.addedTypes = null;
        this.delegate = null;
        this.delegateResult = null;
    }

    private SupportedTypes.Result calculateResult(SupportedTypes delegate, SupportedTypes.Result delegateResult) {
        if (this.filter == null && this.additional == null) {
            return delegateResult;
        }
        ArrayList<ComponentType> list = new ArrayList<ComponentType>(delegateResult.types());
        if (!this.includeParentAdditional && delegate instanceof FilteredTypes) {
            FilteredTypes ft = (FilteredTypes)delegate;
            list.removeAll(ft.addedTypes());
        }
        if (this.filter != null) {
            list.removeIf(Predicate.not(this.filter));
        }
        if (this.additional != null) {
            this.addedTypes = List.copyOf((Collection)this.additional.get());
            list.addAll(this.addedTypes);
        }
        return new SupportedTypes.Result(list);
    }

    private List<ComponentType> addedTypes() {
        return this.addedTypes == null ? List.of() : this.addedTypes;
    }

    public static FilteredTypes create(Container context) {
        return FilteredTypes.create(context, null, null, true);
    }

    public static FilteredTypes create(Container context, Predicate<ComponentType> filter) {
        return FilteredTypes.create(context, filter, null, true);
    }

    public static FilteredTypes create(Container context, Predicate<ComponentType> filter, Supplier<List<ComponentType>> additional) {
        return FilteredTypes.create(context, filter, additional, true);
    }

    public static FilteredTypes create(Container context, Predicate<ComponentType> filter, Supplier<List<ComponentType>> additional, boolean includeParentAdditional) {
        Objects.requireNonNull(context);
        return new FilteredTypes(context, filter, additional, includeParentAdditional);
    }

    private static class BaseDelegate
    implements SupportedTypes {
        private final ComponentRegistry registry;
        private final Predicate<ComponentType> baseFilter;
        private ComponentRegistry.Result registryResult;
        private SupportedTypes.Result result;

        private BaseDelegate(FilteredTypes filteredTypes) {
            this.registry = filteredTypes.context.getLookup().find(ComponentRegistry.class).orElse(null);
            this.baseFilter = filteredTypes.filter != null ? null : BaseDelegate.createBaseFilter(filteredTypes.context);
        }

        public SupportedTypes.Result query() {
            if (this.registry == null) {
                if (this.result == null) {
                    this.result = new SupportedTypes.Result(List.of());
                }
            } else {
                ComponentRegistry.Result regResult = this.registry.query();
                if (this.result == null || regResult != this.registryResult) {
                    this.registryResult = regResult;
                    this.result = this.baseFilter == null ? new SupportedTypes.Result(regResult.componentTypes()) : new SupportedTypes.Result(regResult.componentTypes().stream().filter(this.baseFilter).collect(Collectors.toList()));
                }
            }
            return this.result;
        }

        private static Predicate<ComponentType> createBaseFilter(Container context) {
            String core = "core:";
            String category = BaseDelegate.findRootCategory(context);
            if (category != null) {
                String match = category + ":";
                return type -> type.toString().startsWith(core) || type.toString().startsWith(match);
            }
            return type -> false;
        }

        private static String findRootCategory(Container context) {
            Container c = context;
            Container p = c.getParent();
            while (p != null) {
                c = p;
                p = c.getParent();
            }
            String type = c.getInfo().properties().getString("component-type", "");
            if (type.startsWith("root:")) {
                return type.substring(5);
            }
            return null;
        }
    }
}

