/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.List;
import java.util.function.BinaryOperator;
import org.praxislive.core.Call;
import org.praxislive.core.Control;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Value;
import org.praxislive.core.types.PMap;

public final class MetaProperty
implements Control {
    private final MergeControl mergeControl = new MergeControl();
    private PMap data = PMap.EMPTY;
    private long latest;

    public void call(Call call, PacketRouter router) throws Exception {
        if (call.isRequest()) {
            List args = call.args();
            int argCount = args.size();
            long time = call.time();
            if (argCount > 0) {
                if (argCount > 1) {
                    throw new IllegalArgumentException("Too many arguments");
                }
                if (this.isLatest(time)) {
                    PMap value = (PMap)PMap.from((Value)((Value)args.get(0))).orElseThrow(IllegalArgumentException::new);
                    if (this.data.isEmpty()) {
                        this.data = value;
                    } else if (value.isEmpty()) {
                        this.data = PMap.EMPTY;
                    } else {
                        throw new IllegalStateException("Current or new value must be empty");
                    }
                    this.setLatest(time);
                }
            }
            if (call.isReplyRequired()) {
                router.route((Packet)call.reply((Value)this.data));
            }
        }
    }

    public Control getMergeControl() {
        return this.mergeControl;
    }

    public PMap getValue() {
        return this.data;
    }

    private void setLatest(long time) {
        this.latest = time == 0L ? -1L : time;
    }

    private boolean isLatest(long time) {
        return this.latest == 0L || time - this.latest >= 0L;
    }

    private class MergeControl
    implements Control {
        private MergeControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isRequest()) {
                List args = call.args();
                if (args.size() != 1) {
                    throw new IllegalArgumentException("Wrong number of arguments");
                }
                PMap value = (PMap)PMap.from((Value)((Value)args.get(0))).orElseThrow(IllegalArgumentException::new);
                long time = call.time();
                if (MetaProperty.this.isLatest(time)) {
                    MetaProperty.this.data = MetaProperty.this.data.isEmpty() ? value : PMap.merge((PMap)MetaProperty.this.data, (PMap)value, (BinaryOperator)PMap.REPLACE);
                    MetaProperty.this.setLatest(time);
                }
                if (call.isReplyRequired()) {
                    router.route((Packet)call.reply((Value)MetaProperty.this.data));
                }
            }
        }
    }
}

