/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.List;
import org.praxislive.core.Call;
import org.praxislive.core.Control;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Value;

public abstract class AbstractProperty
implements Control {
    private long latest;

    public void call(Call call, PacketRouter router) throws Exception {
        if (call.isRequest()) {
            List args = call.args();
            int argCount = args.size();
            long time = call.time();
            if (argCount > 0) {
                if (this.isLatest(time)) {
                    this.set(time, (Value)args.get(0));
                    this.setLatest(time);
                }
                if (call.isReplyRequired()) {
                    router.route((Packet)call.reply(args));
                }
            } else {
                router.route((Packet)call.reply(this.get()));
            }
        }
    }

    protected abstract void set(long var1, Value var3) throws Exception;

    protected abstract Value get();

    private void setLatest(long time) {
        this.latest = time == 0L ? -1L : time;
    }

    private boolean isLatest(long time) {
        return this.latest == 0L || time - this.latest >= 0L;
    }
}

