/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;

public abstract class Binding {
    public abstract Optional<ControlInfo> getControlInfo();

    public abstract List<Value> getValues();

    protected abstract void send(Adaptor var1, List<Value> var2);

    protected abstract void updateAdaptorConfiguration(Adaptor var1);

    protected void bind(Adaptor adaptor) {
        adaptor.setBinding(this);
    }

    protected void unbind(Adaptor adaptor) {
        adaptor.setBinding(null);
    }

    public static abstract class Adaptor {
        private Binding binding;
        private SyncRate syncRate = SyncRate.None;
        private boolean active;

        private void setBinding(Binding binding) {
            if (this.binding != null && binding != null) {
                throw new IllegalStateException("Binding adaptor already connected");
            }
            this.binding = binding;
            this.updateBindingConfiguration();
        }

        public final Binding getBinding() {
            return this.binding;
        }

        public final SyncRate getSyncRate() {
            return this.syncRate;
        }

        public final boolean isActive() {
            return this.active;
        }

        public final void setActive(boolean active) {
            if (active != this.active) {
                this.active = active;
                if (this.binding != null) {
                    this.binding.updateAdaptorConfiguration(this);
                }
            }
        }

        public final void setSyncRate(SyncRate syncRate) {
            if (syncRate != this.syncRate) {
                this.syncRate = syncRate;
                if (this.binding != null) {
                    this.binding.updateAdaptorConfiguration(this);
                }
            }
        }

        protected final void send(List<Value> args) {
            if (this.binding != null) {
                this.binding.send(this, args);
            }
        }

        protected boolean getValueIsAdjusting() {
            return false;
        }

        protected void onResponse(List<Value> args) {
        }

        protected void onError(List<Value> args) {
        }

        protected void updateBindingConfiguration() {
        }

        protected void update() {
        }
    }

    public static final class PropertyAdaptor
    extends Adaptor {
        private Value value;
        private ControlInfo info;
        private Consumer<Value> onChangeHandler;
        private Consumer<PropertyAdaptor> onConfigChangeHandler;
        private Consumer<PropertyAdaptor> onSyncHandler;
        private Predicate<PropertyAdaptor> adjustingHandler;

        public Optional<Value> value() {
            return Optional.ofNullable(this.value);
        }

        public Optional<ControlInfo> info() {
            return Optional.ofNullable(this.info);
        }

        public void send(Value value) {
            this.send(List.of(value));
        }

        public PropertyAdaptor onChange(Consumer<Value> onChangeHandler) {
            this.onChangeHandler = onChangeHandler;
            return this;
        }

        public PropertyAdaptor onConfigChange(Consumer<PropertyAdaptor> onConfigChangeHandler) {
            this.onConfigChangeHandler = onConfigChangeHandler;
            return this;
        }

        public PropertyAdaptor onSync(Consumer<PropertyAdaptor> onSyncHandler) {
            this.onSyncHandler = onSyncHandler;
            return this;
        }

        public PropertyAdaptor onCheckAdjusting(Predicate<PropertyAdaptor> adjustingHandler) {
            this.adjustingHandler = adjustingHandler;
            return this;
        }

        @Override
        protected void update() {
            List<Value> values;
            Binding binding = this.getBinding();
            Value oldValue = this.value;
            this.value = this.info != null && binding != null ? ((values = binding.getValues()).size() == 1 ? values.get(0) : null) : null;
            if (!Objects.equals(oldValue, this.value) && this.onChangeHandler != null && this.value != null) {
                this.onChangeHandler.accept(this.value);
            }
            if (this.onSyncHandler != null) {
                this.onSyncHandler.accept(this);
            }
        }

        @Override
        protected boolean getValueIsAdjusting() {
            if (this.adjustingHandler == null) {
                return false;
            }
            return this.adjustingHandler.test(this);
        }

        @Override
        protected void updateBindingConfiguration() {
            this.info = Optional.ofNullable(this.getBinding()).flatMap(Binding::getControlInfo).filter(i -> i.controlType() == ControlInfo.Type.Property || i.controlType() == ControlInfo.Type.ReadOnlyProperty).orElse(null);
            if (this.info == null) {
                this.value = null;
            }
            if (this.onConfigChangeHandler != null) {
                this.onConfigChangeHandler.accept(this);
            }
        }
    }

    public static enum SyncRate {
        None,
        Low,
        Medium,
        High;

    }
}

