/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.praxislive.base.Binding;
import org.praxislive.base.BindingContext;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.ExecutionContext;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Value;
import org.praxislive.core.protocols.ComponentProtocol;

public class BindingContextControl
implements Control,
BindingContext {
    private static final System.Logger LOG = System.getLogger(BindingContextControl.class.getName());
    private static final long LOW_SYNC_DELAY = TimeUnit.MILLISECONDS.toNanos(1000L);
    private static final long MED_SYNC_DELAY = TimeUnit.MILLISECONDS.toNanos(200L);
    private static final long HIGH_SYNC_DELAY = TimeUnit.MILLISECONDS.toNanos(50L);
    private static final long INVOKE_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(5000L);
    private static final long QUIET_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(200L);
    private final ExecutionContext context;
    private final PacketRouter router;
    private final ControlAddress controlAddress;
    private final Map<ControlAddress, BindingImpl> bindings;
    private final Set<BindingImpl> syncing;

    public BindingContextControl(ControlAddress controlAddress, ExecutionContext context, PacketRouter router) {
        this.controlAddress = Objects.requireNonNull(controlAddress);
        this.context = Objects.requireNonNull(context);
        this.router = Objects.requireNonNull(router);
        this.bindings = new LinkedHashMap<ControlAddress, BindingImpl>();
        this.syncing = new CopyOnWriteArraySet<BindingImpl>();
        context.addClockListener(this::tick);
    }

    @Override
    public void bind(ControlAddress address, Binding.Adaptor adaptor) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(adaptor);
        BindingImpl binding = this.bindings.get(address);
        if (binding == null) {
            binding = new BindingImpl(address);
            this.bindings.put(address, binding);
        }
        binding.addAdaptor(adaptor);
    }

    @Override
    public void unbind(ControlAddress address, Binding.Adaptor adaptor) {
        BindingImpl binding = this.bindings.get(address);
        if (binding != null) {
            binding.removeAdaptor(adaptor);
            if (binding.isEmpty()) {
                this.bindings.remove(address);
                binding.dispose();
            }
        }
    }

    public void call(Call call, PacketRouter router) throws Exception {
        if (call.isReply() || call.isError()) {
            if (call.from().controlID().equals("info")) {
                ComponentAddress infoOf = call.from().component();
                this.bindings.forEach((a, b) -> {
                    if (infoOf.equals((Object)a.component())) {
                        b.process(call);
                    }
                });
            } else {
                BindingImpl binding = this.bindings.get(call.from());
                if (binding != null) {
                    binding.process(call);
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void tick(ExecutionContext source) {
        long time = source.getTime();
        this.syncing.forEach(b -> b.processSync(time));
    }

    private class BindingImpl
    extends Binding {
        private final List<Binding.Adaptor> adaptors = new ArrayList<Binding.Adaptor>();
        private final ControlAddress boundAddress;
        private final InfoAdaptor infoAdaptor;
        private ControlInfo bindingInfo;
        private long nextSyncTime;
        private long syncPeriod;
        private boolean isSyncable;
        private boolean isWritableProperty;
        private Call activeCall;
        private Binding.Adaptor activeAdaptor;
        private List<Value> values;

        private BindingImpl(ControlAddress boundAddress) {
            this.boundAddress = boundAddress;
            this.values = List.of();
            if ("info".equals(boundAddress.controlID())) {
                this.infoAdaptor = null;
                this.bindingInfo = ComponentProtocol.INFO_INFO;
                this.isSyncable = true;
            } else {
                ControlAddress infoAddress = boundAddress.component().control("info");
                this.infoAdaptor = new InfoAdaptor();
                this.infoAdaptor.setSyncRate(Binding.SyncRate.Low);
                BindingContextControl.this.bind(infoAddress, this.infoAdaptor);
            }
        }

        @Override
        public Optional<ControlInfo> getControlInfo() {
            return Optional.ofNullable(this.bindingInfo);
        }

        @Override
        public List<Value> getValues() {
            return this.values;
        }

        public String toString() {
            return "BindingImpl : " + String.valueOf(this.boundAddress);
        }

        @Override
        protected void send(Binding.Adaptor adaptor, List<Value> args) {
            Call call = adaptor.getValueIsAdjusting() ? Call.createQuiet((ControlAddress)this.boundAddress, (ControlAddress)BindingContextControl.this.controlAddress, (long)BindingContextControl.this.context.getTime(), args) : Call.create((ControlAddress)this.boundAddress, (ControlAddress)BindingContextControl.this.controlAddress, (long)BindingContextControl.this.context.getTime(), args);
            BindingContextControl.this.router.route((Packet)call);
            this.activeCall = call;
            this.activeAdaptor = adaptor;
            if (this.isWritableProperty) {
                this.values = call.args();
                this.adaptors.forEach(ad -> {
                    if (ad != adaptor) {
                        ad.update();
                    }
                });
            }
        }

        @Override
        protected void updateAdaptorConfiguration(Binding.Adaptor adaptor) {
            this.updateSyncConfiguration();
        }

        private void addAdaptor(Binding.Adaptor adaptor) {
            if (adaptor == null) {
                throw new NullPointerException();
            }
            if (this.adaptors.contains(adaptor)) {
                return;
            }
            this.adaptors.add(adaptor);
            this.bind(adaptor);
            this.updateAdaptorConfiguration(adaptor);
        }

        private void removeAdaptor(Binding.Adaptor adaptor) {
            if (this.adaptors.remove(adaptor)) {
                this.unbind(adaptor);
            }
            this.updateSyncConfiguration();
        }

        private void dispose() {
            if (this.infoAdaptor != null) {
                ControlAddress infoAddress = this.boundAddress.component().control("info");
                BindingContextControl.this.unbind(infoAddress, this.infoAdaptor);
            }
        }

        private boolean isEmpty() {
            return this.adaptors.isEmpty();
        }

        private void updateSyncConfiguration() {
            LOG.log(System.Logger.Level.DEBUG, "Updating sync configuration on {0}", this.boundAddress);
            boolean active = false;
            Binding.SyncRate highRate = Binding.SyncRate.None;
            for (Binding.Adaptor a : this.adaptors) {
                if (!a.isActive()) continue;
                active = true;
                Binding.SyncRate aRate = a.getSyncRate();
                if (aRate.compareTo(highRate) <= 0) continue;
                highRate = aRate;
            }
            if (this.infoAdaptor != null) {
                this.infoAdaptor.setActive(active);
            }
            if (!this.isSyncable || !active || highRate == Binding.SyncRate.None) {
                this.syncPeriod = 0L;
                BindingContextControl.this.syncing.remove(this);
            } else {
                this.syncPeriod = this.delayForRate(highRate);
                this.nextSyncTime = 0L;
                BindingContextControl.this.syncing.add(this);
            }
        }

        private long delayForRate(Binding.SyncRate rate) {
            return switch (rate) {
                default -> throw new MatchException(null, null);
                case Binding.SyncRate.Low -> LOW_SYNC_DELAY;
                case Binding.SyncRate.Medium -> MED_SYNC_DELAY;
                case Binding.SyncRate.High -> HIGH_SYNC_DELAY;
                case Binding.SyncRate.None -> 0L;
            };
        }

        private void updateInfo(ControlInfo info) {
            if (Objects.equals(this.bindingInfo, info)) {
                return;
            }
            if (info != null) {
                ControlInfo.Type type = info.controlType();
                this.isSyncable = type == ControlInfo.Type.Property || type == ControlInfo.Type.ReadOnlyProperty;
                this.isWritableProperty = type == ControlInfo.Type.Property;
            } else {
                this.isSyncable = false;
                this.isWritableProperty = false;
            }
            if (!this.isSyncable) {
                this.values = List.of();
            }
            this.bindingInfo = info;
            for (Binding.Adaptor a : this.adaptors) {
                a.updateBindingConfiguration();
            }
            this.updateSyncConfiguration();
        }

        private void process(Call call) {
            if (call.isReply()) {
                this.processResponse(call);
            } else if (call.isError()) {
                this.processError(call);
            }
        }

        private void processResponse(Call call) {
            if (this.activeCall != null && call.matchID() == this.activeCall.matchID()) {
                if (this.activeAdaptor != null) {
                    this.activeAdaptor.onResponse(call.args());
                    this.activeAdaptor = null;
                }
                if (this.isSyncable) {
                    this.values = call.args();
                    this.adaptors.forEach(Binding.Adaptor::update);
                }
                this.activeCall = null;
            }
        }

        private void processError(Call call) {
            if (this.activeCall != null && call.matchID() == this.activeCall.matchID()) {
                if (this.activeAdaptor != null) {
                    this.activeAdaptor.onError(call.args());
                    this.activeAdaptor = null;
                } else {
                    LOG.log(System.Logger.Level.DEBUG, "Error on sync call - {0}", call.from());
                }
                this.activeCall = null;
            }
        }

        private void processSync(long time) {
            if (this.nextSyncTime == 0L || this.nextSyncTime - time < 0L) {
                this.nextSyncTime = time + this.syncPeriod;
            }
            if (this.activeCall != null && (this.activeCall.isReplyRequired() ? time - this.activeCall.time() < INVOKE_TIMEOUT : time - this.activeCall.time() < QUIET_TIMEOUT)) {
                return;
            }
            if (this.isSyncable) {
                Call call = Call.create((ControlAddress)this.boundAddress, (ControlAddress)BindingContextControl.this.controlAddress, (long)time);
                BindingContextControl.this.router.route((Packet)call);
                this.activeCall = call;
                this.activeAdaptor = null;
            }
        }

        private class InfoAdaptor
        extends Binding.Adaptor {
            private InfoAdaptor() {
            }

            @Override
            protected void update() {
                List<Value> args = this.getBinding().getValues();
                if (!args.isEmpty()) {
                    BindingImpl.this.updateInfo(ComponentInfo.from((Value)args.get(0)).map(cmp -> cmp.controlInfo(BindingImpl.this.boundAddress.controlID())).orElse(null));
                }
            }
        }
    }
}

