/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.base;

import java.util.Collection;
import java.util.PriorityQueue;
import org.praxislive.core.Packet;

class PacketQueue {
    private final PriorityQueue<Packet> q = new PriorityQueue(this::compare);
    private long time;

    PacketQueue(long time) {
        this.time = time;
    }

    private int compare(Packet p1, Packet p2) {
        if (p1 == p2) {
            return 0;
        }
        long timeDiff = p1.time() - p2.time();
        if (timeDiff == 0L) {
            int diff = p1.id() - p2.id();
            return diff < 0 ? -1 : 1;
        }
        return timeDiff < 0L ? -1 : 1;
    }

    void setTime(long time) {
        this.time = time;
    }

    long getTime() {
        return this.time;
    }

    void add(Packet packet) {
        this.q.add(packet);
    }

    Packet poll() {
        if (!this.q.isEmpty() && this.q.peek().time() - this.time <= 0L) {
            return this.q.poll();
        }
        return null;
    }

    void drainTo(Collection<Object> queue) {
        queue.addAll(this.q);
        this.q.clear();
    }
}

