/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services.ivy;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.praxislive.code.LibraryResolver;
import org.praxislive.code.services.ivy.Grappa;
import org.praxislive.code.services.ivy.MavenArtefactInfo;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.types.PResource;

public class IvyResolver
implements LibraryResolver {
    private static final String EXCLUDES = "org.praxislive:* org.jaudiolibs:* com.tinkerforge:* info.picocli:* com.formdev:* net.java.dev.jna:* org.lwjgl:* org.freedesktop.gstreamer:*";
    private final Grappa grappa;
    private final List<MavenArtefactInfo> installed;

    private IvyResolver() {
        Grappa g = null;
        try {
            g = Grappa.create();
            g.setExcludes(EXCLUDES);
        }
        catch (Exception ex) {
            System.getLogger(IvyResolver.class.getName()).log(System.Logger.Level.ERROR, "Unable to initialise Ivy support", (Throwable)ex);
        }
        this.grappa = g;
        this.installed = new ArrayList<MavenArtefactInfo>();
    }

    public Optional<LibraryResolver.Entry> resolve(PResource resource, LibraryResolver.Context context) throws Exception {
        String res = resource.toString();
        if (!res.startsWith("pkg:maven/")) {
            return Optional.empty();
        }
        MavenArtefactInfo artefact = this.parsePURL(res);
        MavenArtefactInfo existing = this.findExisting(artefact);
        if (existing != null) {
            if (!artefact.version().isBlank() && !Objects.equals(existing.version(), artefact.version())) {
                context.log().log(LogLevel.WARNING, resource + " already installed at version " + existing.version());
            }
            return Optional.of(new LibraryResolver.Entry(this.toPURL(existing), List.of()));
        }
        ResolveReport report = this.grappa.resolve(artefact);
        String problemMsg = report.getAllProblemMessages().stream().collect(Collectors.joining("\n"));
        if (report.hasError()) {
            throw new IllegalStateException("Error resolving " + res + (String)(problemMsg.isBlank() ? "" : "\n" + problemMsg));
        }
        if (!problemMsg.isBlank()) {
            context.log().log(LogLevel.WARNING, problemMsg);
        }
        List<IvyNode> nodes = this.grappa.sort(report.getDependencies());
        ArrayList<MavenArtefactInfo> installing = new ArrayList<MavenArtefactInfo>();
        PResource resolved = resource;
        ArrayList<PResource> provides = new ArrayList<PResource>();
        ArrayList<Path> files = new ArrayList<Path>();
        for (IvyNode node : nodes) {
            for (ArtifactDownloadReport download : report.getArtifactsReports(node.getResolvedId())) {
                MavenArtefactInfo info = this.toInfo(download);
                MavenArtefactInfo ex = this.findExisting(info);
                if (ex == null) {
                    PResource purl = this.toPURL(info);
                    if (artefact.isMatchingArtefact(info)) {
                        resolved = purl;
                    }
                    provides.add(purl);
                    installing.add(info);
                    File file = download.getLocalFile();
                    if (file == null) {
                        context.log().log(LogLevel.ERROR, "No file found for " + info);
                        continue;
                    }
                    files.add(file.toPath());
                    continue;
                }
                if (!Objects.equals(info.version(), ex.version())) {
                    context.log().log(LogLevel.WARNING, "Found already installed dependency " + ex + " instead of version " + info.version());
                    continue;
                }
                context.log().log(LogLevel.INFO, "Found already installed dependency " + ex);
            }
        }
        this.installed.addAll(installing);
        return Optional.of(new LibraryResolver.Entry(resolved, files, provides));
    }

    private MavenArtefactInfo parsePURL(String purl) {
        String[] split = (purl = purl.substring(10)).split("\\?");
        if (split.length > 1) {
            throw new IllegalArgumentException("PURL with query section not currently supported");
        }
        purl = split[0];
        split = purl.split("@");
        String version = "";
        if (split.length > 2) {
            throw new IllegalArgumentException("Invalid PURL");
        }
        if (split.length == 2) {
            version = split[1];
        }
        if ((split = (purl = split[0]).split("/")).length != 2) {
            throw new IllegalArgumentException("Invalid PURL");
        }
        String group = split[0];
        String artefact = split[1];
        return new MavenArtefactInfo(group, artefact, version, "");
    }

    private PResource toPURL(MavenArtefactInfo info) {
        return PResource.of((URI)URI.create("pkg:maven/" + info.group() + "/" + info.artefact() + "@" + info.version()));
    }

    private MavenArtefactInfo toInfo(ArtifactDownloadReport report) {
        ModuleRevisionId mrid = report.getArtifact().getId().getModuleRevisionId();
        String group = mrid.getOrganisation();
        String artefact = mrid.getName();
        String version = mrid.getRevision();
        String classifier = report.getArtifact().getId().getQualifiedExtraAttributes().getOrDefault("classifier", "");
        return new MavenArtefactInfo(group, artefact, version, classifier);
    }

    private MavenArtefactInfo findExisting(MavenArtefactInfo artefact) {
        return this.installed.stream().filter(artefact::isMatchingArtefact).findFirst().orElse(null);
    }

    public static class Provider
    implements LibraryResolver.Provider {
        public LibraryResolver createResolver() {
            return new IvyResolver();
        }
    }
}

