/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services.ivy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.util.DefaultMessageLogger;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.praxislive.code.services.ivy.IvyResolver;
import org.praxislive.code.services.ivy.MavenArtefactInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;

class Grappa {
    private final Ivy ivy;
    private List<ExcludeRule> excludes;

    private Grappa(Ivy ivy) {
        this.ivy = ivy;
        this.excludes = List.of();
    }

    void setExcludes(String excludes) {
        this.excludes = List.copyOf(this.parseExcludes(excludes));
    }

    List<IvyNode> sort(final List<IvyNode> nodes) {
        return (List)this.ivy.execute(new Ivy.IvyCallback(){

            public Object doInIvyContext(Ivy ivy, IvyContext context) {
                return ivy.sortNodes((Collection)nodes, SortOptions.DEFAULT);
            }
        });
    }

    ResolveReport resolve(final MavenArtefactInfo dep) {
        return (ResolveReport)this.ivy.execute(new Ivy.IvyCallback(){

            public Object doInIvyContext(Ivy ivy, IvyContext context) {
                long millis = System.currentTimeMillis();
                DefaultModuleDescriptor md = new DefaultModuleDescriptor(ModuleRevisionId.newInstance((String)"grappa", (String)"all-grappa", (String)("working" + millis)), "integration", null, true);
                md.addConfiguration(new Configuration("default"));
                md.setLastModified(millis);
                String version = dep.version().isBlank() ? "latest.release" : dep.version();
                ModuleRevisionId mrid = ModuleRevisionId.newInstance((String)dep.group(), (String)dep.artefact(), (String)version);
                DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor((ModuleDescriptor)md, mrid, false, false, true);
                dd.addDependencyConfiguration("default", "default");
                if (dep.classifier() != null && !dep.classifier().isBlank()) {
                    DefaultDependencyArtifactDescriptor dad = new DefaultDependencyArtifactDescriptor((DependencyDescriptor)dd, mrid.getName(), "jar", "jar", null, Map.of("classifier", dep.classifier()));
                    dd.addDependencyArtifact("default", (DependencyArtifactDescriptor)dad);
                }
                md.addDependency((DependencyDescriptor)dd);
                Grappa.this.excludes.forEach(arg_0 -> ((DefaultModuleDescriptor)md).addExcludeRule(arg_0));
                ResolveOptions options = new ResolveOptions();
                options.setConfs(new String[]{"default"});
                options.setOutputReport(false);
                ResolveReport report = null;
                int attempt = 8;
                while (true) {
                    try {
                        report = ivy.resolve((ModuleDescriptor)md, options);
                    }
                    catch (Exception e) {
                        if (attempt-- > 0) {
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ex) {
                                throw new RuntimeException(ex);
                            }
                            continue;
                        }
                        throw new RuntimeException(e);
                    }
                    break;
                }
                ResolutionCacheManager cacheManager = ivy.getResolutionCacheManager();
                cacheManager.getResolvedIvyFileInCache(md.getModuleRevisionId()).delete();
                cacheManager.getResolvedIvyPropertiesInCache(md.getModuleRevisionId()).delete();
                return report;
            }
        });
    }

    private List<ExcludeRule> parseExcludes(String excludes) {
        try {
            PArray arr = PArray.parse((String)excludes);
            ArrayList<ExcludeRule> lst = new ArrayList<ExcludeRule>(arr.size());
            for (Value v : arr) {
                String[] split = v.toString().split(":");
                if (split.length != 2) {
                    throw new IllegalArgumentException();
                }
                DefaultExcludeRule exclude = new DefaultExcludeRule(new ArtifactId(new ModuleId(split[0], split[1]), "*", "*", "*"), (PatternMatcher)ExactPatternMatcher.INSTANCE, null);
                exclude.addConfiguration("default");
                lst.add((ExcludeRule)exclude);
            }
            return lst;
        }
        catch (Exception ex) {
            System.getLogger(IvyResolver.class.getName()).log(System.Logger.Level.ERROR, "Invalid excludes", (Throwable)ex);
            return List.of();
        }
    }

    static Grappa create() throws Exception {
        Ivy ivy = Ivy.newInstance();
        ivy.configureDefault();
        return new Grappa(ivy);
    }

    static {
        Message.setDefaultLogger((MessageLogger)new DefaultMessageLogger(-1));
    }
}

