/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services.ivy;

import java.util.Objects;

class MavenArtefactInfo {
    private final String group;
    private final String artefact;
    private final String version;
    private final String classifier;

    public MavenArtefactInfo(String group, String artefact, String version) {
        this(group, artefact, version, "");
    }

    public MavenArtefactInfo(String group, String artefact, String version, String classifier) {
        this.group = group;
        this.artefact = artefact;
        this.version = version;
        this.classifier = classifier;
    }

    public String group() {
        return this.group;
    }

    public String artefact() {
        return this.artefact;
    }

    public String version() {
        return this.version;
    }

    public String classifier() {
        return this.classifier;
    }

    public boolean isMatchingArtefact(MavenArtefactInfo info) {
        return Objects.equals(this.group, info.group()) && Objects.equals(this.artefact, info.artefact()) && Objects.equals(this.classifier, info.classifier());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.group);
        hash = 97 * hash + Objects.hashCode(this.artefact);
        hash = 97 * hash + Objects.hashCode(this.version);
        hash = 97 * hash + Objects.hashCode(this.classifier);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenArtefactInfo other = (MavenArtefactInfo)obj;
        if (!Objects.equals(this.group, other.group)) {
            return false;
        }
        if (!Objects.equals(this.artefact, other.artefact)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        return Objects.equals(this.classifier, other.classifier);
    }

    public String toString() {
        return "MavenArtefactInfo{group=" + this.group + ",artefact=" + this.artefact + ",version=" + this.version + ",classifier=" + this.classifier + "}";
    }
}

