/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services.mima;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.praxislive.code.LibraryResolver;
import org.praxislive.code.services.mima.MimaWrapper;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.types.PResource;
import org.praxislive.purl.PackageURL;

public class MimaResolver
implements LibraryResolver {
    MimaWrapper mima;

    public Optional<LibraryResolver.Entry> resolve(PResource resource, LibraryResolver.Context context) throws Exception {
        String res = resource.toString();
        if (!res.startsWith("pkg:maven/")) {
            return Optional.empty();
        }
        Artifact artifact = MimaResolver.parsePURL(res);
        List<Artifact> installed = MimaResolver.buildInstalledList(context.provided().toList());
        Artifact existing = MimaResolver.findExisting(installed, artifact);
        if (existing != null) {
            if (!artifact.getVersion().isBlank() && !Objects.equals(existing.getVersion(), artifact.getVersion())) {
                context.log().log(LogLevel.WARNING, String.valueOf(resource) + " already installed at version " + existing.getVersion());
            }
            return Optional.of(new LibraryResolver.Entry(MimaResolver.toPURL(existing), List.of()));
        }
        if (this.mima == null) {
            this.mima = new MimaWrapper();
        }
        List<Artifact> resolved = this.mima.resolve(artifact, installed);
        PResource root = resource;
        ArrayList<PResource> provides = new ArrayList<PResource>();
        ArrayList<Path> files = new ArrayList<Path>();
        for (Artifact dep : resolved) {
            Artifact ex = MimaResolver.findExisting(installed, dep);
            if (ex == null) {
                Path file = dep.getFile().toPath();
                PResource purl = MimaResolver.toPURL(dep);
                if (MimaResolver.matchingArtifacts(dep, artifact)) {
                    root = purl;
                }
                provides.add(purl);
                files.add(file);
                context.log().log(LogLevel.INFO, "Installing dependency " + String.valueOf(purl));
                continue;
            }
            if (!Objects.equals(dep.getVersion(), ex.getVersion())) {
                context.log().log(LogLevel.WARNING, "Found already installed dependency " + String.valueOf(MimaResolver.toPURL(ex)) + " instead of version " + dep.getVersion());
                continue;
            }
            context.log().log(LogLevel.INFO, "Found already installed dependency " + String.valueOf(MimaResolver.toPURL(ex)));
        }
        return Optional.of(new LibraryResolver.Entry(root, files, provides));
    }

    public void dispose() {
        if (this.mima != null) {
            this.mima.dispose();
            this.mima = null;
        }
    }

    private static Artifact parsePURL(String purlString) {
        PackageURL purl = PackageURL.parse((String)purlString);
        return new DefaultArtifact((String)purl.namespace().orElseThrow(IllegalArgumentException::new), purl.name(), purl.qualifiers().flatMap(q -> Optional.ofNullable((String)q.get("classifier"))).orElse(""), purl.qualifiers().flatMap(q -> Optional.ofNullable((String)q.get("type"))).orElse("jar"), purl.version().orElse(""));
    }

    private static PResource toPURL(Artifact artifact) {
        PackageURL.Builder builder = PackageURL.builder().withType("maven").withNamespace(artifact.getGroupId()).withName(artifact.getArtifactId());
        if (!artifact.getVersion().isBlank()) {
            builder.withVersion(artifact.getVersion());
        }
        if (!artifact.getClassifier().isBlank()) {
            builder.withQualifier("classifier", artifact.getClassifier());
        }
        if (!"jar".equals(artifact.getExtension())) {
            builder.withQualifier("type", artifact.getExtension());
        }
        return PResource.of((URI)builder.build().toURI());
    }

    private static List<Artifact> buildInstalledList(List<PResource> provided) {
        if (provided.isEmpty()) {
            return List.of();
        }
        ArrayList<Artifact> list = new ArrayList<Artifact>(provided.size());
        for (PResource res : provided) {
            String str = res.toString();
            if (!str.startsWith("pkg:maven/")) continue;
            try {
                list.add(MimaResolver.parsePURL(str));
            }
            catch (Exception exception) {}
        }
        return List.copyOf(list);
    }

    private static Artifact findExisting(List<Artifact> installed, Artifact artifact) {
        return installed.stream().filter(lib -> MimaResolver.matchingArtifacts(lib, artifact)).findFirst().orElse(null);
    }

    private static boolean matchingArtifacts(Artifact art1, Artifact art2) {
        return Objects.equals(art1, art2) || Objects.equals(art1.getGroupId(), art2.getGroupId()) && Objects.equals(art1.getArtifactId(), art2.getArtifactId()) && Objects.equals(art1.getClassifier(), art2.getClassifier()) && Objects.equals(art1.getExtension(), art2.getExtension());
    }

    public static final class Provider
    implements LibraryResolver.Provider {
        public LibraryResolver createResolver() {
            return new MimaResolver();
        }
    }
}

