/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services.mima;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.Runtime;
import eu.maveniverse.maven.mima.context.Runtimes;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;

class MimaWrapper {
    private final Context context;

    MimaWrapper() {
        Runtime runtime = Runtimes.INSTANCE.getRuntime();
        this.context = runtime.create(ContextOverrides.create().withUserSettings(true).build());
    }

    List<Artifact> resolve(Artifact artifact, List<Artifact> existing) throws DependencyResolutionException {
        Dependency dependency = new Dependency(artifact, "compile");
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(dependency);
        collectRequest.setRepositories(this.context.remoteRepositories());
        if (existing != null && !existing.isEmpty()) {
            collectRequest.setManagedDependencies(existing.stream().map(a -> new Dependency(a, "compile")).toList());
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, (node, parents) -> node.getDependency().getOptional() == false);
        DependencyResult dependencyResult = this.context.repositorySystem().resolveDependencies(this.context.repositorySystemSession(), dependencyRequest);
        List artifacts = dependencyResult.getArtifactResults();
        return artifacts.stream().filter(ArtifactResult::isResolved).map(ArtifactResult::getArtifact).toList();
    }

    void dispose() {
        this.context.close();
    }
}

