/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.praxislive.base.AbstractAsyncControl;
import org.praxislive.base.AbstractRoot;
import org.praxislive.code.ClassBodyContext;
import org.praxislive.code.CodeCompilerService;
import org.praxislive.code.CodeComponent;
import org.praxislive.code.CodeComponentFactoryService;
import org.praxislive.code.CodeContext;
import org.praxislive.code.CodeContextFactoryService;
import org.praxislive.code.CodeDelegate;
import org.praxislive.code.CodeFactory;
import org.praxislive.code.services.ClassCacheKey;
import org.praxislive.code.services.ComponentRegistry;
import org.praxislive.code.services.PMapClassLoader;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Lookup;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.RootHub;
import org.praxislive.core.Value;
import org.praxislive.core.services.ComponentFactory;
import org.praxislive.core.services.LogBuilder;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.services.Service;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PReference;
import org.praxislive.core.types.PResource;

public class DefaultCodeFactoryService
extends AbstractRoot
implements RootHub.ServiceProvider {
    private static final ConcurrentMap<ClassCacheKey, Class<? extends CodeDelegate>> CODE_CACHE = new ConcurrentHashMap<ClassCacheKey, Class<? extends CodeDelegate>>();
    private final Map<String, Control> controls = Map.of("new-instance", new NewInstanceControl(), "new-context", new NewContextControl());
    private final ComponentRegistry registry = ComponentRegistry.getInstance();
    private final Set<PResource> libs = new LinkedHashSet<PResource>();
    private LibraryClassloader libClassloader;

    public List<Class<? extends Service>> services() {
        return List.of(CodeComponentFactoryService.class, CodeContextFactoryService.class);
    }

    protected void activating() {
        this.libClassloader = new LibraryClassloader(Thread.currentThread().getContextClassLoader());
    }

    protected void processCall(Call call, PacketRouter router) {
        try {
            this.controls.get(call.to().controlID()).call(call, router);
        }
        catch (Exception ex) {
            router.route((Packet)call.error(PError.of((Exception)ex)));
        }
    }

    private ControlAddress findCompilerService() throws Exception {
        return ControlAddress.of((ComponentAddress)this.findService(CodeCompilerService.class), (String)"compile");
    }

    private PMap createCompilerTask(ClassBodyContext<?> cbc, LogLevel logLevel, String source) {
        return PMap.of((String)"class-body-context", (Object)cbc.getClass().getName(), (String)"log-level", (Object)logLevel.asPString(), (String)"code", (Object)source);
    }

    private Class<? extends CodeDelegate> extractCodeDelegateClass(Value response) throws Exception {
        PMap data = (PMap)PMap.from((Value)response).orElseThrow();
        PMap classes = (PMap)PMap.from((Value)data.get("classes")).orElseThrow();
        PArray.from((Value)data.get("ext-classpath")).ifPresent(this::processExtClasspath);
        PMapClassLoader classLoader = new PMapClassLoader(classes, (ClassLoader)this.libClassloader);
        return classLoader.loadClass("$");
    }

    private void processExtClasspath(PArray extCP) {
        if (extCP.isEmpty()) {
            return;
        }
        List extLibs = extCP.stream().map(v -> (PResource)PResource.from((Value)v).orElseThrow(() -> new IllegalArgumentException())).collect(Collectors.toCollection(ArrayList::new));
        extLibs.removeAll(this.libs);
        Lookup lkp = this.getLookup();
        extLibs.forEach(res -> {
            URI lib = res.resolve(lkp).stream().filter(uri -> !"file".equals(uri.getScheme()) || new File((URI)uri).exists()).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't find library : " + res));
            try {
                this.libClassloader.addURL(lib.toURL());
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex);
            }
            this.libs.add((PResource)res);
        });
    }

    private void extractCompilerLog(Value response, LogBuilder logBuilder) throws Exception {
        PMap data = (PMap)PMap.from((Value)response).orElseThrow();
        PArray log = (PArray)PArray.from((Value)data.get("log")).orElseThrow();
        for (int i = 0; i < log.size(); i += 2) {
            logBuilder.log(LogLevel.valueOf((String)log.get(i).toString()), log.get(i + 1).toString());
        }
    }

    private static class LibraryClassloader
    extends URLClassLoader {
        public LibraryClassloader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        @Override
        protected void addURL(URL url) {
            super.addURL(url);
        }
    }

    private class NewContextControl
    extends AbstractAsyncControl {
        private NewContextControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            Class cls;
            CodeContextFactoryService.Task<CodeDelegate> task = this.findTask();
            CodeFactory factory = task.getFactory();
            ClassBodyContext cbc = factory.getClassBodyContext();
            String src = task.getCode();
            if (src.trim().isEmpty()) {
                src = factory.getSourceTemplate();
                cls = (Class)CODE_CACHE.get(new ClassCacheKey(cbc, src));
            } else {
                cls = null;
            }
            if (cls != null) {
                LogBuilder log = new LogBuilder(task.getLogLevel());
                CodeDelegate delegate = (CodeDelegate)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return call.reply((Value)PReference.of(this.createContext(task, log, delegate)));
            }
            return Call.create((ControlAddress)DefaultCodeFactoryService.this.findCompilerService(), (ControlAddress)call.to(), (long)call.time(), (Value)DefaultCodeFactoryService.this.createCompilerTask(cbc, LogLevel.ERROR, src));
        }

        protected Call processResponse(Call call) throws Exception {
            try {
                CodeContextFactoryService.Task<CodeDelegate> task = this.findTask();
                Class<? extends CodeDelegate> cls = DefaultCodeFactoryService.this.extractCodeDelegateClass((Value)call.args().get(0));
                CodeDelegate delegate = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LogBuilder log = new LogBuilder(task.getLogLevel());
                DefaultCodeFactoryService.this.extractCompilerLog((Value)call.args().get(0), log);
                return this.getActiveCall().reply((Value)PReference.of(this.createContext(task, log, delegate)));
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new Exception(throwable);
            }
        }

        private CodeContextFactoryService.Task<CodeDelegate> findTask() throws Exception {
            return (CodeContextFactoryService.Task)PReference.from((Value)((Value)this.getActiveCall().args().get(0))).flatMap(r -> r.as(CodeContextFactoryService.Task.class)).orElseThrow();
        }

        private CodeContextFactoryService.Result<CodeDelegate> createContext(CodeContextFactoryService.Task<CodeDelegate> task, LogBuilder log, CodeDelegate delegate) {
            CodeContext context = task.getFactory().task().attachPrevious(task.getPrevious()).attachLogging(log).createContext(delegate);
            return new CodeContextFactoryService.Result(context, log);
        }
    }

    private class NewInstanceControl
    extends AbstractAsyncControl {
        private NewInstanceControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            CodeFactory<CodeDelegate> codeFactory = this.findCodeFactory();
            ClassBodyContext cbc = codeFactory.getClassBodyContext();
            String src = codeFactory.getSourceTemplate();
            Class cls = codeFactory.getDefaultDelegateClass().orElseGet(() -> (Class)CODE_CACHE.get(new ClassCacheKey(cbc, src)));
            if (cls != null) {
                return call.reply((Value)PReference.of(this.createComponent(codeFactory, cls)));
            }
            return Call.create((ControlAddress)DefaultCodeFactoryService.this.findCompilerService(), (ControlAddress)call.to(), (long)call.time(), (Value)DefaultCodeFactoryService.this.createCompilerTask(cbc, LogLevel.ERROR, src));
        }

        protected Call processResponse(Call call) throws Exception {
            try {
                CodeFactory<CodeDelegate> codeFactory = this.findCodeFactory();
                Class<? extends CodeDelegate> cls = DefaultCodeFactoryService.this.extractCodeDelegateClass((Value)call.args().get(0));
                CodeDelegate delegate = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                CodeComponent cmp = codeFactory.task().createComponent(delegate);
                CODE_CACHE.putIfAbsent(new ClassCacheKey(codeFactory.getClassBodyContext(), codeFactory.getSourceTemplate()), cls);
                return this.getActiveCall().reply((Value)PReference.of((Object)cmp));
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new Exception(throwable);
            }
        }

        private CodeFactory<CodeDelegate> findCodeFactory() throws Exception {
            ComponentType type = (ComponentType)ComponentType.from((Value)((Value)this.getActiveCall().args().get(0))).orElseThrow();
            ComponentFactory cmpFactory = DefaultCodeFactoryService.this.registry.getComponentFactory(type);
            return cmpFactory.getMetaData(type).getLookup().find(CodeFactory.class).orElse(null);
        }

        private CodeComponent<CodeDelegate> createComponent(CodeFactory<CodeDelegate> codeFactory, Class<? extends CodeDelegate> delegateClass) throws Exception {
            return codeFactory.task().createComponent(delegateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
    }
}

