/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services.tools;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

class MultiReader
extends Reader {
    private static final Reader EMPTY_READER = new StringReader("");
    private final List<Reader> delegates;
    private final Iterator<Reader> delegateIterator;
    private Reader currentDelegate = EMPTY_READER;

    public MultiReader(List<Reader> delegates) {
        this.delegates = delegates;
        this.delegateIterator = delegates.iterator();
    }

    public MultiReader(Reader[] delegates) {
        this(Arrays.asList(delegates));
    }

    @Override
    public void close() throws IOException {
        for (Reader delegate : this.delegates) {
            delegate.close();
        }
    }

    @Override
    public int read() throws IOException {
        int result;
        while ((result = this.currentDelegate.read()) == -1) {
            if (!this.delegateIterator.hasNext()) {
                return -1;
            }
            this.currentDelegate = this.delegateIterator.next();
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = 0L;
        while (true) {
            long result;
            if ((result = this.currentDelegate.skip(n - skipped)) != -1L) {
                if ((skipped += result) != n) continue;
                return skipped;
            }
            if (!this.delegateIterator.hasNext()) {
                return skipped;
            }
            this.currentDelegate = this.delegateIterator.next();
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = 0;
        while (true) {
            long result;
            if ((result = (long)this.currentDelegate.read(cbuf, off + read, len - read)) != -1L) {
                if ((read = (int)((long)read + result)) != len) continue;
                return read;
            }
            if (!this.delegateIterator.hasNext()) {
                return read == 0 ? -1 : read;
            }
            this.currentDelegate = this.delegateIterator.next();
        }
    }
}

