/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.praxislive.code.services.tools.ByteArrayJavaFileManager;
import org.praxislive.code.services.tools.ByteMapClassLoader;
import org.praxislive.code.services.tools.CompilationException;
import org.praxislive.code.services.tools.MessageHandler;

class SimpleCompiler {
    private MessageHandler messageHandler;
    private Map<String, byte[]> classes;
    private JavaCompiler compiler;
    private List<String> options;

    SimpleCompiler() {
    }

    public Map<String, byte[]> getCompiledClasses() {
        return this.classes;
    }

    public ClassLoader getClassLoader() {
        this.assertCooked();
        return new ByteMapClassLoader(this.classes, Thread.currentThread().getContextClassLoader());
    }

    protected void cook(Reader r) throws CompilationException, IOException {
        this.assertNotCooked();
        final String code = new BufferedReader(r).lines().collect(Collectors.joining("\n"));
        SimpleJavaFileObject compilationUnit = new SimpleJavaFileObject(URI.create("simplecompiler"), JavaFileObject.Kind.SOURCE){

            @Override
            public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
                return true;
            }

            @Override
            public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                return new StringReader(code);
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return code;
            }

            @Override
            public String toString() {
                return String.valueOf(this.uri);
            }
        };
        if (this.compiler == null) {
            this.compiler = ToolProvider.getSystemJavaCompiler();
            if (this.compiler == null) {
                throw new CompilationException("JDK Java compiler not available - probably you're running a JRE, not a JDK", null);
            }
        }
        StandardJavaFileManager fm = this.compiler.getStandardFileManager(null, null, null);
        ByteArrayJavaFileManager fileManager = new ByteArrayJavaFileManager(fm);
        try {
            final CompilationException[] caughtCompilationException = new CompilationException[1];
            if (!this.compiler.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                    block7: {
                        String message = "[" + diagnostic.getLineNumber() + ":" + diagnostic.getColumnNumber() + "] " + diagnostic.getMessage(null) + " (" + diagnostic.getCode() + ")";
                        try {
                            switch (diagnostic.getKind()) {
                                case ERROR: {
                                    if (SimpleCompiler.this.messageHandler != null) {
                                        SimpleCompiler.this.messageHandler.handleError(message);
                                    }
                                    throw new CompilationException(message);
                                }
                                case MANDATORY_WARNING: 
                                case WARNING: {
                                    if (SimpleCompiler.this.messageHandler == null) break;
                                    SimpleCompiler.this.messageHandler.handleWarning(message);
                                    break;
                                }
                            }
                        }
                        catch (CompilationException ce) {
                            if (caughtCompilationException[0] != null) break block7;
                            caughtCompilationException[0] = ce;
                        }
                    }
                }
            }, this.options == null ? Arrays.asList("-Xlint:all") : this.options, null, Collections.singleton(compilationUnit)).call().booleanValue()) {
                if (caughtCompilationException[0] != null) {
                    throw caughtCompilationException[0];
                }
                throw new CompilationException("Compilation failed", null);
            }
        }
        catch (RuntimeException rte) {
            for (Throwable t = rte.getCause(); t != null; t = t.getCause()) {
                if (t instanceof CompilationException) {
                    throw (CompilationException)t;
                }
                if (!(t instanceof IOException)) continue;
                throw (IOException)t;
            }
            throw rte;
        }
        this.classes = fileManager.extractClassData();
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void setCompiler(JavaCompiler compiler) {
        this.compiler = compiler;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    protected void assertCooked() {
        if (this.classes == null) {
            throw new IllegalStateException("Not yet cooked");
        }
    }

    protected void assertNotCooked() {
        if (this.classes != null) {
            throw new IllegalStateException("Already cooked");
        }
    }
}

