/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.praxislive.code.CodeComponentFactoryService;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Lookup;
import org.praxislive.core.services.ComponentFactory;
import org.praxislive.core.services.ComponentFactoryProvider;

class ComponentRegistry {
    private static final Logger logger = Logger.getLogger(ComponentRegistry.class.getName());
    private final Map<ComponentType, ComponentFactory> componentCache;

    private ComponentRegistry(Map<ComponentType, ComponentFactory> componentCache) {
        this.componentCache = componentCache;
    }

    ComponentType[] getComponentTypes() {
        Set<ComponentType> keys = this.componentCache.keySet();
        return keys.toArray(new ComponentType[keys.size()]);
    }

    ComponentFactory getComponentFactory(ComponentType type) {
        return this.componentCache.get(type);
    }

    static ComponentRegistry getInstance() {
        LinkedHashMap<ComponentType, ComponentFactory> componentCache = new LinkedHashMap<ComponentType, ComponentFactory>();
        Lookup.SYSTEM.findAll(ComponentFactoryProvider.class).map(ComponentFactoryProvider::getFactory).filter(factory -> factory.getFactoryService() == CodeComponentFactoryService.class).forEachOrdered(factory -> factory.componentTypes().forEachOrdered(type -> componentCache.put((ComponentType)type, (ComponentFactory)factory)));
        return new ComponentRegistry(componentCache);
    }
}

