/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.praxislive.base.AbstractAsyncControl;
import org.praxislive.base.AbstractRoot;
import org.praxislive.code.ClassBodyContext;
import org.praxislive.code.CodeCompilerService;
import org.praxislive.code.CodeComponent;
import org.praxislive.code.CodeComponentFactoryService;
import org.praxislive.code.CodeContext;
import org.praxislive.code.CodeContextFactoryService;
import org.praxislive.code.CodeDelegate;
import org.praxislive.code.CodeFactory;
import org.praxislive.code.SharedCodeService;
import org.praxislive.code.services.ClassCacheKey;
import org.praxislive.code.services.ComponentRegistry;
import org.praxislive.code.services.PMapClassLoader;
import org.praxislive.code.services.tools.ClassBodyWrapper;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Lookup;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.RootHub;
import org.praxislive.core.Value;
import org.praxislive.core.services.ComponentFactory;
import org.praxislive.core.services.LogBuilder;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.services.Service;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PBytes;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PReference;
import org.praxislive.core.types.PResource;

public class DefaultCodeFactoryService
extends AbstractRoot
implements RootHub.ServiceProvider {
    private static final ConcurrentMap<ClassCacheKey, Class<? extends CodeDelegate>> CODE_CACHE = new ConcurrentHashMap<ClassCacheKey, Class<? extends CodeDelegate>>();
    private static final String SHARED_PREFIX = "SHARED.";
    private static final String WRAPPED_CLASS_NAME = "$";
    private final Map<String, Control> controls = Map.of("new-instance", new NewInstanceControl(), "new-context", new NewContextControl(), "new-shared", new NewSharedControl());
    private final ComponentRegistry registry = ComponentRegistry.getInstance();
    private final Set<PResource> libs = new LinkedHashSet<PResource>();
    private LibraryClassloader libClassloader;

    public List<Class<? extends Service>> services() {
        return List.of(CodeComponentFactoryService.class, CodeContextFactoryService.class, SharedCodeService.class);
    }

    protected void activating() {
        this.libClassloader = new LibraryClassloader(Thread.currentThread().getContextClassLoader());
    }

    protected void processCall(Call call, PacketRouter router) {
        try {
            this.controls.get(call.to().controlID()).call(call, router);
        }
        catch (Exception ex) {
            router.route((Packet)call.error(PError.of((Exception)ex)));
        }
    }

    private ControlAddress findCompilerService() throws Exception {
        return ControlAddress.of((ComponentAddress)this.findService(CodeCompilerService.class), (String)"compile");
    }

    private String wrapClassBody(String fullClassName, ClassBodyContext<?> cbc, String code) {
        return ClassBodyWrapper.create().className(fullClassName).extendsType(cbc.getExtendedClass()).implementsTypes(List.of(cbc.getImplementedInterfaces())).defaultImports(List.of(cbc.getDefaultImports())).wrap(code);
    }

    private Class<? extends CodeDelegate> extractCodeDelegateClass(PMap data, ClassLoader parentClassLoader) throws Exception {
        PMap classes = (PMap)PMap.from((Value)data.get("classes")).orElseThrow();
        String className = classes.keys().stream().filter(name -> WRAPPED_CLASS_NAME.equals(name) || name.endsWith(".$")).findFirst().orElseThrow();
        PArray.from((Value)data.get("ext-classpath")).ifPresent(this::processExtClasspath);
        PMapClassLoader classLoader = new PMapClassLoader(classes, parentClassLoader == null ? this.libClassloader : parentClassLoader);
        return classLoader.loadClass(className);
    }

    private void processExtClasspath(PArray extCP) {
        if (extCP.isEmpty()) {
            return;
        }
        List extLibs = extCP.stream().map(v -> (PResource)PResource.from((Value)v).orElseThrow(() -> new IllegalArgumentException())).collect(Collectors.toCollection(ArrayList::new));
        extLibs.removeAll(this.libs);
        Lookup lkp = this.getLookup();
        extLibs.forEach(res -> {
            URI lib = res.resolve(lkp).stream().filter(uri -> !"file".equals(uri.getScheme()) || new File((URI)uri).exists()).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't find library : " + res));
            try {
                this.libClassloader.addURL(lib.toURL());
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex);
            }
            this.libs.add((PResource)res);
        });
    }

    private void extractCompilerLog(PMap data, LogBuilder logBuilder) throws Exception {
        PArray log = (PArray)PArray.from((Value)data.get("log")).orElseThrow();
        for (int i = 0; i < log.size(); i += 2) {
            logBuilder.log(LogLevel.valueOf((String)log.get(i).toString()), log.get(i + 1).toString());
        }
    }

    static String codeAddressToPackage(ControlAddress address) {
        String pkg = address.toString().replace("/", ".").replace("_", WRAPPED_CLASS_NAME).replace("-", "_");
        return DefaultCodeFactoryService.genCodePrefix() + pkg;
    }

    static boolean codeAddressMatchesPackage(ControlAddress address, String pkg) {
        if (!pkg.startsWith("CODE")) {
            return false;
        }
        String addressPkg = DefaultCodeFactoryService.codeAddressToPackage(address);
        return addressPkg.substring(addressPkg.indexOf(".")).equals(pkg.substring(pkg.indexOf(".")));
    }

    private static String genCodePrefix() {
        return String.format(Locale.ROOT, "CODE%04x", (int)(Math.random() * 65535.0));
    }

    private static class LibraryClassloader
    extends URLClassLoader {
        public LibraryClassloader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        @Override
        protected void addURL(URL url) {
            super.addURL(url);
        }
    }

    private class NewSharedControl
    extends AbstractAsyncControl {
        private NewSharedControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            SharedCodeService.Task task = this.findTask();
            PMap sources = this.validateSources(task.getSources());
            if (sources.isEmpty() && task.getDependents().isEmpty()) {
                return call.reply((Value)PReference.of((Object)new SharedCodeService.Result()));
            }
            Map<String, String> dependentSources = this.processDependentSources(task);
            if (!dependentSources.isEmpty()) {
                sources = this.mergeSources(sources, dependentSources);
            }
            return Call.create((ControlAddress)DefaultCodeFactoryService.this.findCompilerService(), (ControlAddress)call.to(), (long)call.time(), (Value)PMap.of((String)"sources", (Object)sources, (String)"log-level", (Object)task.getLogLevel()));
        }

        protected Call processResponse(Call call) throws Exception {
            PMap data = (PMap)PMap.from((Value)((Value)call.args().get(0))).orElseThrow();
            PMap classes = (PMap)PMap.from((Value)data.get("classes")).orElseThrow();
            SharedCodeService.Task task = this.findTask();
            PArray.from((Value)data.get("ext-classpath")).ifPresent(ext -> DefaultCodeFactoryService.this.processExtClasspath((PArray)ext));
            Map<String, List<String>> partionedClasses = this.partitionClasses(classes);
            ClassLoader sharedClasses = this.createClassloader(DefaultCodeFactoryService.this.libClassloader, classes, partionedClasses.get(DefaultCodeFactoryService.SHARED_PREFIX));
            LogBuilder log = new LogBuilder(task.getLogLevel());
            DefaultCodeFactoryService.this.extractCompilerLog(data, log);
            Map<ControlAddress, SharedCodeService.DependentResult> depResults = task.getDependents().entrySet().stream().map(e -> Map.entry((ControlAddress)e.getKey(), this.processDependent((ControlAddress)e.getKey(), sharedClasses, log, (SharedCodeService.DependentTask)e.getValue(), classes, partionedClasses))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
            SharedCodeService.Result result = new SharedCodeService.Result(sharedClasses, depResults, log);
            return this.getActiveCall().reply((Value)PReference.of((Object)result));
        }

        private SharedCodeService.Task findTask() throws Exception {
            return (SharedCodeService.Task)PReference.from((Value)((Value)this.getActiveCall().args().get(0))).flatMap(r -> r.as(SharedCodeService.Task.class)).orElseThrow();
        }

        private PMap validateSources(PMap sources) {
            if (!sources.keys().stream().allMatch(name -> name.startsWith(DefaultCodeFactoryService.SHARED_PREFIX))) {
                throw new IllegalArgumentException("Sources contains class outside SHARED package");
            }
            return sources;
        }

        private Map<String, String> processDependentSources(SharedCodeService.Task task) {
            return task.getDependents().entrySet().stream().map(e -> {
                ControlAddress depAddress = (ControlAddress)e.getKey();
                SharedCodeService.DependentTask depTask = (SharedCodeService.DependentTask)e.getValue();
                String clsName = DefaultCodeFactoryService.codeAddressToPackage(depAddress) + ".$";
                String source = DefaultCodeFactoryService.this.wrapClassBody(clsName, depTask.getFactory().getClassBodyContext(), depTask.getExistingSource());
                return Map.entry(clsName, source);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private PMap mergeSources(PMap shared, Map<String, String> dependents) {
            PMap.Builder b = PMap.builder();
            shared.keys().stream().forEach(k -> b.put(k, shared.get(k)));
            dependents.entrySet().forEach(e -> b.put((String)e.getKey(), (String)e.getValue()));
            return b.build();
        }

        private Map<String, List<String>> partitionClasses(PMap classes) {
            return classes.keys().stream().collect(Collectors.groupingBy(cls -> {
                if (cls.startsWith(DefaultCodeFactoryService.SHARED_PREFIX)) {
                    return DefaultCodeFactoryService.SHARED_PREFIX;
                }
                return cls.substring(0, cls.lastIndexOf("."));
            }));
        }

        private ClassLoader createClassloader(ClassLoader parent, PMap classes, List<String> classFilter) {
            PMap.Builder b = PMap.builder();
            classFilter.forEach(cls -> b.put(cls, (Value)PBytes.from((Value)classes.get(cls)).orElseThrow()));
            return new PMapClassLoader(b.build(), parent);
        }

        private SharedCodeService.DependentResult processDependent(ControlAddress address, ClassLoader parent, LogBuilder log, SharedCodeService.DependentTask depTask, PMap allClasses, Map<String, List<String>> partionedClasses) {
            try {
                List reqClasses = partionedClasses.entrySet().stream().filter(e -> DefaultCodeFactoryService.codeAddressMatchesPackage(address, (String)e.getKey())).map(Map.Entry::getValue).findFirst().orElseThrow();
                ClassLoader depClassLoader = this.createClassloader(parent, allClasses, reqClasses);
                String className = reqClasses.stream().filter(name -> DefaultCodeFactoryService.WRAPPED_CLASS_NAME.equals(name) || name.endsWith(".$")).findFirst().orElseThrow();
                Class<?> depClass = depClassLoader.loadClass(className);
                CodeContext context = depTask.getFactory().task().attachLogging(log).attachPrevious(depTask.getExistingClass()).createContext((CodeDelegate)depClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                return new SharedCodeService.DependentResult(context, depTask.getExistingClass());
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    private class NewContextControl
    extends AbstractAsyncControl {
        private boolean usingShared;

        private NewContextControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            Class cls;
            this.usingShared = false;
            CodeContextFactoryService.Task<CodeDelegate> task = this.findTask();
            CodeFactory factory = task.getFactory();
            ClassBodyContext cbc = factory.getClassBodyContext();
            String src = task.getCode();
            if (src.isBlank()) {
                src = factory.getSourceTemplate();
                cls = (Class)CODE_CACHE.get(new ClassCacheKey(cbc, src));
            } else {
                cls = null;
            }
            if (cls != null) {
                LogBuilder log = new LogBuilder(task.getLogLevel());
                CodeDelegate delegate = (CodeDelegate)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return call.reply((Value)PReference.of(this.createContext(task, log, delegate)));
            }
            this.usingShared = src.contains(DefaultCodeFactoryService.SHARED_PREFIX);
            String fullClassName = DefaultCodeFactoryService.codeAddressToPackage(call.from()) + ".$";
            return Call.create((ControlAddress)DefaultCodeFactoryService.this.findCompilerService(), (ControlAddress)call.to(), (long)call.time(), (Value)this.createCompilerTask(task, cbc, fullClassName, src, this.usingShared));
        }

        protected Call processResponse(Call call) throws Exception {
            boolean shared = this.usingShared;
            this.usingShared = false;
            try {
                PMap data = (PMap)PMap.from((Value)((Value)call.args().get(0))).orElseThrow(IllegalArgumentException::new);
                CodeContextFactoryService.Task<CodeDelegate> task = this.findTask();
                Class<? extends CodeDelegate> cls = DefaultCodeFactoryService.this.extractCodeDelegateClass(data, shared ? task.getSharedClassLoader() : null);
                CodeDelegate delegate = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LogBuilder log = new LogBuilder(task.getLogLevel());
                DefaultCodeFactoryService.this.extractCompilerLog(data, log);
                return this.getActiveCall().reply((Value)PReference.of(this.createContext(task, log, delegate)));
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new Exception(throwable);
            }
        }

        protected Call processError(Call call) throws Exception {
            this.usingShared = false;
            return super.processError(call);
        }

        private CodeContextFactoryService.Task<CodeDelegate> findTask() throws Exception {
            return (CodeContextFactoryService.Task)PReference.from((Value)((Value)this.getActiveCall().args().get(0))).flatMap(r -> r.as(CodeContextFactoryService.Task.class)).orElseThrow();
        }

        private CodeContextFactoryService.Result<CodeDelegate> createContext(CodeContextFactoryService.Task<CodeDelegate> task, LogBuilder log, CodeDelegate delegate) {
            CodeContext context = task.getFactory().task().attachPrevious(task.getPrevious()).attachLogging(log).createContext(delegate);
            return new CodeContextFactoryService.Result(context, log);
        }

        private PMap createCompilerTask(CodeContextFactoryService.Task<?> task, ClassBodyContext<?> cbc, String fullClassName, String code, boolean shared) {
            String source = DefaultCodeFactoryService.this.wrapClassBody(fullClassName, cbc, code);
            if (shared) {
                ClassLoader sharedCL = task.getSharedClassLoader();
                PMap sharedClasses = sharedCL instanceof PMapClassLoader ? ((PMapClassLoader)sharedCL).getClassesMap() : PMap.EMPTY;
                return PMap.of((String)"sources", (Object)PMap.of((String)fullClassName, (Object)source), (String)"log-level", (Object)task.getLogLevel(), (String)"shared-classes", (Object)sharedClasses);
            }
            return PMap.of((String)"sources", (Object)PMap.of((String)fullClassName, (Object)source), (String)"log-level", (Object)task.getLogLevel());
        }
    }

    private class NewInstanceControl
    extends AbstractAsyncControl {
        private NewInstanceControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            CodeFactory<CodeDelegate> codeFactory = this.findCodeFactory();
            ClassBodyContext cbc = codeFactory.getClassBodyContext();
            String src = codeFactory.getSourceTemplate();
            Class cls = codeFactory.getDefaultDelegateClass().orElseGet(() -> (Class)CODE_CACHE.get(new ClassCacheKey(cbc, src)));
            if (cls != null) {
                return call.reply((Value)PReference.of(this.createComponent(codeFactory, cls)));
            }
            return Call.create((ControlAddress)DefaultCodeFactoryService.this.findCompilerService(), (ControlAddress)call.to(), (long)call.time(), (Value)this.createCompilerTask(cbc, src));
        }

        protected Call processResponse(Call call) throws Exception {
            try {
                PMap data = (PMap)PMap.from((Value)((Value)call.args().get(0))).orElseThrow(IllegalArgumentException::new);
                CodeFactory<CodeDelegate> codeFactory = this.findCodeFactory();
                Class<? extends CodeDelegate> cls = DefaultCodeFactoryService.this.extractCodeDelegateClass(data, null);
                CodeDelegate delegate = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                CodeComponent cmp = codeFactory.task().createComponent(delegate);
                CODE_CACHE.putIfAbsent(new ClassCacheKey(codeFactory.getClassBodyContext(), codeFactory.getSourceTemplate()), cls);
                return this.getActiveCall().reply((Value)PReference.of((Object)cmp));
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new Exception(throwable);
            }
        }

        private CodeFactory<CodeDelegate> findCodeFactory() throws Exception {
            ComponentType type = (ComponentType)ComponentType.from((Value)((Value)this.getActiveCall().args().get(0))).orElseThrow();
            ComponentFactory cmpFactory = DefaultCodeFactoryService.this.registry.getComponentFactory(type);
            return cmpFactory.getMetaData(type).getLookup().find(CodeFactory.class).orElse(null);
        }

        private CodeComponent<CodeDelegate> createComponent(CodeFactory<CodeDelegate> codeFactory, Class<? extends CodeDelegate> delegateClass) throws Exception {
            return codeFactory.task().createComponent(delegateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }

        private PMap createCompilerTask(ClassBodyContext<?> cbc, String code) {
            String fullClassName = DefaultCodeFactoryService.genCodePrefix() + ".NEW_INSTANCE.$";
            String source = DefaultCodeFactoryService.this.wrapClassBody(fullClassName, cbc, code);
            return PMap.of((String)"sources", (Object)PMap.of((String)fullClassName, (Object)source));
        }
    }
}

