/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services.tools;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ClassBodyWrapper {
    private static final String NEW_LINE = "\n";
    private List<String> defaultImports = List.of();
    private String className = "$";
    private Class<?> extendedType;
    private List<Class<?>> implementedTypes = List.of();
    private static final Pattern IMPORT_STATEMENT_PATTERN = Pattern.compile("\\bimport\\s+((?:static\\s+)?[\\p{javaLowerCase}\\p{javaUpperCase}_\\$][\\p{javaLowerCase}\\p{javaUpperCase}\\d_\\$]*(?:\\.[\\p{javaLowerCase}\\p{javaUpperCase}_\\$][\\p{javaLowerCase}\\p{javaUpperCase}\\d_\\$]*)*(?:\\.\\*)?);");

    private ClassBodyWrapper() {
    }

    public ClassBodyWrapper className(String className) {
        this.className = Objects.requireNonNull(className);
        return this;
    }

    public ClassBodyWrapper defaultImports(List<String> defaultImports) {
        this.defaultImports = List.copyOf(defaultImports);
        return this;
    }

    public ClassBodyWrapper extendsType(Class<?> extendedType) {
        this.extendedType = extendedType;
        return this;
    }

    public ClassBodyWrapper implementsTypes(List<Class<?>> implementedTypes) {
        this.implementedTypes = List.copyOf(implementedTypes);
        return this;
    }

    public String wrap(String source) {
        String simpleClassName;
        String packageName;
        StringBuilder sb = new StringBuilder();
        Map<Boolean, List<String>> partitionedSource = source.lines().collect(Collectors.partitioningBy(IMPORT_STATEMENT_PATTERN.asPredicate()));
        List<String> sourceImports = partitionedSource.get(true);
        List<String> sourceBody = partitionedSource.get(false);
        int idx = this.className.lastIndexOf(46);
        if (idx == -1) {
            packageName = "";
            simpleClassName = this.className;
        } else {
            packageName = this.className.substring(0, idx);
            simpleClassName = this.className.substring(idx + 1);
        }
        if (!packageName.isEmpty()) {
            sb.append("package ").append(packageName).append(";").append(NEW_LINE);
        }
        this.defaultImports.forEach(i -> sb.append("import ").append((String)i).append(";").append(NEW_LINE));
        sourceImports.forEach(i -> sb.append((String)i).append(NEW_LINE));
        sb.append("public class ").append(simpleClassName);
        if (this.extendedType != null) {
            sb.append(" extends ").append(this.extendedType.getCanonicalName());
        }
        if (!this.implementedTypes.isEmpty()) {
            sb.append(" implements ");
            sb.append(this.implementedTypes.stream().map(Class::getName).collect(Collectors.joining(", ")));
        }
        sb.append(" {").append(NEW_LINE);
        sourceBody.forEach(line -> sb.append((String)line).append(NEW_LINE));
        sb.append("}").append(NEW_LINE);
        return sb.toString();
    }

    public static ClassBodyWrapper create() {
        return new ClassBodyWrapper();
    }
}

