/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services.tools;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.tools.JavaCompiler;
import org.praxislive.code.ClassBodyContext;
import org.praxislive.code.services.tools.ClassBodyWrapper;
import org.praxislive.code.services.tools.CompilationException;
import org.praxislive.code.services.tools.CompilerTask;
import org.praxislive.code.services.tools.MessageHandler;

public class ClassBodyCompiler {
    public static final String DEFAULT_CLASS_NAME = "$";
    private final ClassBodyContext<?> classBodyContext;
    private final Set<File> extClasspath;
    private final String defClasspath;
    private final String defModulepath;
    private MessageHandler messageHandler;
    private JavaCompiler compiler;
    private SourceVersion release;

    private ClassBodyCompiler(ClassBodyContext<?> classBodyContext) {
        this.classBodyContext = classBodyContext;
        this.release = SourceVersion.RELEASE_11;
        this.extClasspath = new LinkedHashSet<File>();
        this.defClasspath = System.getProperty("java.class.path", "");
        this.defModulepath = System.getProperty("jdk.module.path", "");
    }

    public ClassBodyCompiler addMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    @Deprecated
    public ClassBodyCompiler extendClasspath(Set<File> libs) {
        this.extClasspath.addAll(libs);
        return this;
    }

    public ClassBodyCompiler extendClasspath(List<File> libs) {
        this.extClasspath.addAll(libs);
        return this;
    }

    public ClassBodyCompiler setCompiler(JavaCompiler compiler) {
        this.compiler = compiler;
        return this;
    }

    public ClassBodyCompiler setRelease(SourceVersion release) {
        this.release = release;
        return this;
    }

    public Map<String, byte[]> compile(String code) throws CompilationException {
        try {
            String source = ClassBodyWrapper.create().className(DEFAULT_CLASS_NAME).extendsType(this.classBodyContext.getExtendedClass()).implementsTypes(List.of(this.classBodyContext.getImplementedInterfaces())).defaultImports(List.of(this.classBodyContext.getDefaultImports())).wrap(code);
            CompilerTask task = CompilerTask.create(Map.of(DEFAULT_CLASS_NAME, source));
            if (this.messageHandler != null) {
                task.messageHandler(this.messageHandler);
            }
            List<String> opts = List.of("-Xlint:all", "-proc:none", "--release", String.valueOf(this.release.ordinal()), "--add-modules", "ALL-MODULE-PATH", "--module-path", this.defModulepath, "-classpath", this.buildClasspath());
            task.options(opts);
            return task.compile();
        }
        catch (CompilationException ex) {
            throw new CompilationException(ex);
        }
        catch (Exception ex) {
            throw new CompilationException(ex);
        }
    }

    private String buildClasspath() {
        if (this.extClasspath.isEmpty()) {
            return this.defClasspath;
        }
        return this.extClasspath.stream().map(f -> f.getAbsolutePath()).collect(Collectors.joining(File.pathSeparator, "", File.pathSeparator + this.defClasspath));
    }

    public static ClassBodyCompiler create(ClassBodyContext<?> classBodyContext) {
        return new ClassBodyCompiler(classBodyContext);
    }
}

