/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

class MemoryJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final Map<JavaFileManager.Location, Map<JavaFileObject.Kind, Map<String, JavaFileObject>>> javaFiles = new HashMap<JavaFileManager.Location, Map<JavaFileObject.Kind, Map<String, JavaFileObject>>>();

    public MemoryJavaFileManager(JavaFileManager delegate) {
        super(delegate);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) {
        throw new UnsupportedOperationException("getFileForInput");
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) {
        throw new UnsupportedOperationException("getFileForInput");
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        Map<JavaFileObject.Kind, Map<String, JavaFileObject>> locationJavaFiles = this.javaFiles.get(location);
        if (locationJavaFiles == null) {
            return null;
        }
        Map<String, JavaFileObject> kindJavaFiles = locationJavaFiles.get((Object)kind);
        if (kindJavaFiles == null) {
            return null;
        }
        return kindJavaFiles.get(className);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        MemoryJavaFileObject fileObject = kind == JavaFileObject.Kind.SOURCE ? new StringWriterJavaFileObject(className, kind) : new ByteArrayJavaFileObject(className, kind);
        this.getFileMap(location, kind).put(className, fileObject);
        return fileObject;
    }

    public JavaFileObject addSource(String className, String source) {
        StringJavaFileObject file = new StringJavaFileObject(className, JavaFileObject.Kind.SOURCE, source);
        this.getFileMap(StandardLocation.SOURCE_PATH, JavaFileObject.Kind.SOURCE).put(className, file);
        return file;
    }

    public JavaFileObject addExistingClass(String className, Supplier<InputStream> byteSource) {
        InputStreamFileObject file = new InputStreamFileObject(className, JavaFileObject.Kind.CLASS, byteSource);
        this.getFileMap(StandardLocation.CLASS_PATH, JavaFileObject.Kind.CLASS).put(className, file);
        return file;
    }

    private Map<String, JavaFileObject> getFileMap(JavaFileManager.Location location, JavaFileObject.Kind kind) {
        Map<String, JavaFileObject> kindJavaFiles;
        Map<JavaFileObject.Kind, Map<String, JavaFileObject>> locationJavaFiles = this.javaFiles.get(location);
        if (locationJavaFiles == null) {
            locationJavaFiles = new HashMap<JavaFileObject.Kind, Map<String, JavaFileObject>>();
            this.javaFiles.put(location, locationJavaFiles);
        }
        if ((kindJavaFiles = locationJavaFiles.get((Object)kind)) == null) {
            kindJavaFiles = new TreeMap<String, JavaFileObject>();
            locationJavaFiles.put(kind, kindJavaFiles);
        }
        return kindJavaFiles;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof MemoryJavaFileObject) {
            return ((MemoryJavaFileObject)file).binaryName;
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.javaFiles.containsKey(location) || super.hasLocation(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Map<JavaFileObject.Kind, Map<String, JavaFileObject>> locationFiles = this.javaFiles.get(location);
        Iterable<JavaFileObject> stdList = super.list(location, packageName, kinds, recurse);
        if (locationFiles == null) {
            return stdList;
        }
        Object prefix = packageName.length() == 0 ? "" : packageName + ".";
        int pl = ((String)prefix).length();
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        for (JavaFileObject.Kind kind : kinds) {
            Map<String, JavaFileObject> kindFiles = locationFiles.get((Object)kind);
            if (kindFiles == null) continue;
            for (Map.Entry<String, JavaFileObject> e : kindFiles.entrySet()) {
                String className = e.getKey();
                if (!className.startsWith((String)prefix) || !recurse && className.indexOf(46, pl) != -1) continue;
                result.add(e.getValue());
            }
        }
        return () -> Stream.concat(result.stream(), StreamSupport.stream(stdList.spliterator(), false)).iterator();
    }

    Map<String, byte[]> extractClassData() {
        TreeMap<String, byte[]> bytecode = new TreeMap<String, byte[]>();
        Map<JavaFileObject.Kind, Map<String, JavaFileObject>> locationFiles = this.javaFiles.get(StandardLocation.CLASS_OUTPUT);
        Map<String, JavaFileObject> classFiles = locationFiles.get((Object)JavaFileObject.Kind.CLASS);
        classFiles.entrySet().stream().forEach(type -> bytecode.put((String)type.getKey(), ((ByteArrayJavaFileObject)type.getValue()).toByteArray()));
        return bytecode;
    }

    static class InputStreamFileObject
    extends MemoryJavaFileObject {
        final Supplier<InputStream> streamSource;

        public InputStreamFileObject(String binaryName, JavaFileObject.Kind kind, Supplier<InputStream> streamSource) {
            super("bytestream", binaryName, kind);
            this.streamSource = Objects.requireNonNull(streamSource);
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.streamSource.get();
        }
    }

    static class StringJavaFileObject
    extends MemoryJavaFileObject {
        final String source;

        public StringJavaFileObject(String binaryName, JavaFileObject.Kind kind, String source) {
            super("string", binaryName, kind);
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return new StringReader(this.source);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.source;
        }
    }

    static class StringWriterJavaFileObject
    extends MemoryJavaFileObject {
        final StringWriter buffer = new StringWriter();

        public StringWriterJavaFileObject(String binaryName, JavaFileObject.Kind kind) {
            super("stringwriter", binaryName, kind);
        }

        @Override
        public Writer openWriter() throws IOException {
            return this.buffer;
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return new StringReader(this.buffer.toString());
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.buffer.getBuffer();
        }
    }

    static class ByteArrayJavaFileObject
    extends MemoryJavaFileObject {
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        public ByteArrayJavaFileObject(String binaryName, JavaFileObject.Kind kind) {
            super("bytearray", binaryName, kind);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.buffer;
        }

        public byte[] toByteArray() {
            return this.buffer.toByteArray();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new ByteArrayInputStream(this.toByteArray());
        }
    }

    static abstract class MemoryJavaFileObject
    extends SimpleJavaFileObject {
        private final String binaryName;

        MemoryJavaFileObject(String protocol, String binaryName, JavaFileObject.Kind kind) {
            super(URI.create(protocol + ":///" + binaryName.replace('.', '/') + kind.extension), kind);
            this.binaryName = binaryName;
        }
    }
}

