/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services;

import org.praxislive.core.Value;
import org.praxislive.core.types.PBytes;
import org.praxislive.core.types.PMap;

class PMapClassLoader
extends ClassLoader {
    private final PMap classes;

    PMapClassLoader(PMap classes, ClassLoader parent) {
        super(parent);
        this.classes = classes;
    }

    PMap getClassesMap() {
        return this.classes;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Value dataArg = this.classes.get(name);
        if (dataArg == null) {
            throw new ClassNotFoundException(name);
        }
        PBytes data = (PBytes)PBytes.from((Value)dataArg).orElseThrow(() -> new ClassNotFoundException(name));
        byte[] bytes = new byte[data.size()];
        data.read(bytes);
        return this.defineClass(name, bytes, 0, bytes.length);
    }
}

