/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.praxislive.code.CodeCompilerService;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Value;
import org.praxislive.core.services.ServiceUnavailableException;
import org.praxislive.core.services.Services;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PResource;
import org.praxislive.script.AbstractSingleCallFrame;
import org.praxislive.script.Command;
import org.praxislive.script.CommandInstaller;
import org.praxislive.script.Env;
import org.praxislive.script.InlineCommand;
import org.praxislive.script.Namespace;

public class CompilerCommandInstaller
implements CommandInstaller {
    public void install(Map<String, Command> commands) {
        commands.put("add-lib", (namespace, args) -> new AddLibs(namespace, args, false));
        commands.put("add-libs", (namespace, args) -> new AddLibs(namespace, args, true));
        commands.put("libraries", Libraries::new);
        commands.put("libraries-all", LibrariesAll::new);
        commands.put("libraries-system", LibrariesSystem::new);
        commands.put("libraries-path", LibrariesPath::new);
        commands.put("java-compiler-release", JavaRelease::new);
        commands.put("compiler", Compiler::new);
    }

    private static class AddLibs
    extends AbstractSingleCallFrame {
        private final boolean array;

        AddLibs(Namespace namespace, List<Value> args, boolean array) {
            super(namespace, args);
            this.array = array;
        }

        protected Call createCall(Env env, List<Value> args) throws Exception {
            PArray libs = this.array ? (PArray)PArray.from((Value)args.get(0)).orElseThrow(IllegalArgumentException::new) : PArray.of((Value[])new Value[]{args.get(0)});
            ComponentAddress service = (ComponentAddress)env.getLookup().find(Services.class).flatMap(sm -> sm.locate(CodeCompilerService.class)).orElseThrow(ServiceUnavailableException::new);
            ControlAddress addLibsControl = ControlAddress.of((ComponentAddress)service, (String)"add-libs");
            return Call.create((ControlAddress)addLibsControl, (ControlAddress)env.getAddress(), (long)env.getTime(), (Value)libs);
        }
    }

    private static class JavaRelease
    extends AbstractSingleCallFrame {
        JavaRelease(Namespace namespace, List<Value> args) {
            super(namespace, args);
        }

        protected Call createCall(Env env, List<Value> args) throws Exception {
            ComponentAddress service = (ComponentAddress)env.getLookup().find(Services.class).flatMap(sm -> sm.locate(CodeCompilerService.class)).orElseThrow(ServiceUnavailableException::new);
            ControlAddress releaseControl = ControlAddress.of((ComponentAddress)service, (String)"release");
            return Call.create((ControlAddress)releaseControl, (ControlAddress)env.getAddress(), (long)env.getTime(), args);
        }
    }

    private static class Compiler
    extends AbstractSingleCallFrame {
        private Compiler(Namespace namespace, List<Value> args) {
            super(namespace, args);
        }

        protected Call createCall(Env env, List<Value> args) throws Exception {
            PMap params = (PMap)PMap.from((Value)args.get(0)).orElseThrow(IllegalArgumentException::new);
            ComponentAddress service = (ComponentAddress)env.getLookup().find(Services.class).flatMap(sm -> sm.locate(CodeCompilerService.class)).orElseThrow(ServiceUnavailableException::new);
            ControlAddress releaseControl = ControlAddress.of((ComponentAddress)service, (String)"release");
            return Call.create((ControlAddress)releaseControl, (ControlAddress)env.getAddress(), (long)env.getTime(), (Value)params.get("release"));
        }
    }

    private static class LibrariesPath
    extends AbstractSingleCallFrame {
        private LibrariesPath(Namespace namespace, List<Value> args) {
            super(namespace, args);
        }

        protected Call createCall(Env env, List<Value> args) throws Exception {
            ComponentAddress service = (ComponentAddress)env.getLookup().find(Services.class).flatMap(sm -> sm.locate(CodeCompilerService.class)).orElseThrow(ServiceUnavailableException::new);
            return Call.create((ControlAddress)ControlAddress.of((ComponentAddress)service, (String)"libraries-path"), (ControlAddress)env.getAddress(), (long)env.getTime());
        }
    }

    private static class LibrariesSystem
    extends AbstractSingleCallFrame {
        private LibrariesSystem(Namespace namespace, List<Value> args) {
            super(namespace, args);
        }

        protected Call createCall(Env env, List<Value> args) throws Exception {
            ComponentAddress service = (ComponentAddress)env.getLookup().find(Services.class).flatMap(sm -> sm.locate(CodeCompilerService.class)).orElseThrow(ServiceUnavailableException::new);
            return Call.create((ControlAddress)ControlAddress.of((ComponentAddress)service, (String)"libraries-system"), (ControlAddress)env.getAddress(), (long)env.getTime());
        }
    }

    private static class LibrariesAll
    extends AbstractSingleCallFrame {
        private LibrariesAll(Namespace namespace, List<Value> args) {
            super(namespace, args);
        }

        protected Call createCall(Env env, List<Value> args) throws Exception {
            ComponentAddress service = (ComponentAddress)env.getLookup().find(Services.class).flatMap(sm -> sm.locate(CodeCompilerService.class)).orElseThrow(ServiceUnavailableException::new);
            return Call.create((ControlAddress)ControlAddress.of((ComponentAddress)service, (String)"libraries-all"), (ControlAddress)env.getAddress(), (long)env.getTime());
        }
    }

    private static class Libraries
    extends AbstractSingleCallFrame {
        private Libraries(Namespace namespace, List<Value> args) {
            super(namespace, args);
        }

        protected Call createCall(Env env, List<Value> args) throws Exception {
            ComponentAddress service = (ComponentAddress)env.getLookup().find(Services.class).flatMap(sm -> sm.locate(CodeCompilerService.class)).orElseThrow(ServiceUnavailableException::new);
            if (args.isEmpty()) {
                ControlAddress librariesProperty = ControlAddress.of((ComponentAddress)service, (String)"libraries");
                return Call.create((ControlAddress)librariesProperty, (ControlAddress)env.getAddress(), (long)env.getTime());
            }
            PArray libs = (PArray)((PArray)PArray.from((Value)args.get(0)).orElseThrow(IllegalArgumentException::new)).stream().flatMap(lib -> this.expand(env, (Value)lib).stream()).collect(PArray.collector());
            ControlAddress addLibsControl = ControlAddress.of((ComponentAddress)service, (String)"add-libs");
            return Call.create((ControlAddress)addLibsControl, (ControlAddress)env.getAddress(), (long)env.getTime(), (Value)libs);
        }

        private List<PResource> expand(Env context, Value lib) {
            return PResource.from((Value)lib).map(List::of).orElseGet(() -> this.listFiles(context, lib));
        }

        private List<PResource> listFiles(Env context, Value lib) {
            try {
                Value response = (Value)((InlineCommand)this.getNamespace().getCommand("file-list")).process(context, this.getNamespace(), List.of(lib)).get(0);
                return ((PArray)PArray.from((Value)response).orElseThrow()).stream().map(v -> (PResource)PResource.from((Value)v).orElseThrow()).collect(Collectors.toList());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

