/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services;

import java.util.LinkedHashMap;
import java.util.Optional;
import org.praxislive.code.CodeComponentFactoryService;
import org.praxislive.code.CodeDelegate;
import org.praxislive.code.CodeFactory;
import org.praxislive.code.CodeRootFactoryService;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Lookup;
import org.praxislive.core.OrderedMap;
import org.praxislive.core.services.ComponentFactory;
import org.praxislive.core.services.ComponentFactoryProvider;

class ComponentRegistry {
    private final OrderedMap<ComponentType, ComponentFactory> componentCache;
    private final OrderedMap<Class<? extends CodeDelegate>, CodeFactory.Base<CodeDelegate>> baseCache;

    private ComponentRegistry(OrderedMap<ComponentType, ComponentFactory> componentCache, OrderedMap<Class<? extends CodeDelegate>, CodeFactory.Base<CodeDelegate>> baseCache) {
        this.componentCache = componentCache;
        this.baseCache = baseCache;
    }

    ComponentFactory getComponentFactory(ComponentType type) {
        return (ComponentFactory)this.componentCache.get((Object)type);
    }

    CodeFactory.Base<CodeDelegate> findSuitableBase(Class<? extends CodeDelegate> cls) {
        for (Class<? extends CodeDelegate> c = cls; c != CodeDelegate.class && c != null; c = c.getSuperclass()) {
            CodeFactory.Base base = (CodeFactory.Base)this.baseCache.get(c);
            if (base == null) continue;
            return base;
        }
        return null;
    }

    static ComponentRegistry getInstance() {
        LinkedHashMap components = new LinkedHashMap();
        LinkedHashMap bases = new LinkedHashMap();
        Lookup.SYSTEM.findAll(ComponentFactoryProvider.class).map(ComponentFactoryProvider::getFactory).filter(factory -> factory.componentRedirect().filter(r -> r.service() == CodeComponentFactoryService.class).isPresent()).forEachOrdered(factory -> factory.componentTypes().forEachOrdered(type -> {
            components.put(type, factory);
            CodeFactory.Base<CodeDelegate> base = ComponentRegistry.findBase(factory, type);
            if (base != null) {
                bases.putIfAbsent(base.baseClass(), base);
            }
        }));
        Lookup.SYSTEM.findAll(ComponentFactoryProvider.class).map(ComponentFactoryProvider::getFactory).filter(factory -> factory.rootRedirect().filter(r -> r.service() == CodeRootFactoryService.class).isPresent()).forEachOrdered(factory -> factory.rootTypes().forEachOrdered(type -> {
            components.put(type, factory);
            CodeFactory.Base<CodeDelegate> base = ComponentRegistry.findBase(factory, type);
            if (base != null) {
                bases.putIfAbsent(base.baseClass(), base);
            }
        }));
        return new ComponentRegistry((OrderedMap<ComponentType, ComponentFactory>)OrderedMap.copyOf(components), (OrderedMap<Class<? extends CodeDelegate>, CodeFactory.Base<CodeDelegate>>)OrderedMap.copyOf(bases));
    }

    private static CodeFactory.Base<CodeDelegate> findBase(ComponentFactory factory, ComponentType type) {
        return Optional.ofNullable(factory.componentData(type)).flatMap(data -> data.find(CodeFactory.class)).map(CodeFactory::lookup).flatMap(data -> data.find(CodeFactory.Base.class)).orElse(null);
    }
}

