/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services.tools;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ClassBodyWrapper {
    private static final String NEW_LINE = "\n";
    private List<String> defaultImports = List.of();
    private String className = "$";
    private Class<?> extendedType;
    private List<Class<?>> implementedTypes = List.of();
    private static final Pattern IMPORT_STATEMENT_PATTERN = Pattern.compile("\\s*import\\s+((?:static\\s+)?\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.\\*)?);");
    private static final Pattern EXTENDS_STATEMENT_PATTERN = Pattern.compile("\\s*extends\\s+(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.\\*)?);");

    private ClassBodyWrapper() {
    }

    public ClassBodyWrapper className(String className) {
        this.className = Objects.requireNonNull(className);
        return this;
    }

    public ClassBodyWrapper defaultImports(List<String> defaultImports) {
        this.defaultImports = List.copyOf(defaultImports);
        return this;
    }

    public ClassBodyWrapper extendsType(Class<?> extendedType) {
        this.extendedType = extendedType;
        return this;
    }

    public ClassBodyWrapper implementsTypes(List<Class<?>> implementedTypes) {
        this.implementedTypes = List.copyOf(implementedTypes);
        return this;
    }

    public String wrap(String source) {
        String simpleClassName;
        String packageName;
        String superclass;
        StringBuilder sb = new StringBuilder();
        Map partitionedSource = source.lines().collect(Collectors.groupingBy(ClassBodyWrapper::categorize, () -> new EnumMap(LineCategory.class), Collectors.toList()));
        List sourceExtends = partitionedSource.getOrDefault((Object)LineCategory.EXTENDS, List.of());
        if (sourceExtends.isEmpty()) {
            superclass = this.extendedType != null ? this.extendedType.getCanonicalName() : null;
        } else {
            if (sourceExtends.size() > 1) {
                throw new IllegalArgumentException("Multiple extends declarations found");
            }
            Matcher matcher = EXTENDS_STATEMENT_PATTERN.matcher((CharSequence)sourceExtends.get(0));
            if (!matcher.lookingAt()) {
                throw new IllegalStateException();
            }
            superclass = matcher.group(1);
        }
        List sourceImports = partitionedSource.getOrDefault((Object)LineCategory.IMPORT, List.of());
        List sourceBody = partitionedSource.getOrDefault((Object)LineCategory.BODY, List.of());
        int idx = this.className.lastIndexOf(46);
        if (idx == -1) {
            packageName = "";
            simpleClassName = this.className;
        } else {
            packageName = this.className.substring(0, idx);
            simpleClassName = this.className.substring(idx + 1);
        }
        if (!packageName.isEmpty()) {
            sb.append("package ").append(packageName).append(";").append(NEW_LINE);
        }
        this.defaultImports.forEach(i -> sb.append("import ").append((String)i).append(";").append(NEW_LINE));
        sourceImports.forEach(i -> sb.append((String)i).append(NEW_LINE));
        sb.append("public class ").append(simpleClassName);
        if (superclass != null) {
            sb.append(" extends ").append(superclass);
        }
        if (!this.implementedTypes.isEmpty()) {
            sb.append(" implements ");
            sb.append(this.implementedTypes.stream().map(Class::getName).collect(Collectors.joining(", ")));
        }
        sb.append(" {").append(NEW_LINE);
        sourceBody.forEach(line -> sb.append((String)line).append(NEW_LINE));
        sb.append("}").append(NEW_LINE);
        return sb.toString();
    }

    public static ClassBodyWrapper create() {
        return new ClassBodyWrapper();
    }

    private static LineCategory categorize(String line) {
        if (IMPORT_STATEMENT_PATTERN.matcher(line).lookingAt()) {
            return LineCategory.IMPORT;
        }
        if (EXTENDS_STATEMENT_PATTERN.matcher(line).lookingAt()) {
            return LineCategory.EXTENDS;
        }
        return LineCategory.BODY;
    }

    private static enum LineCategory {
        BODY,
        IMPORT,
        EXTENDS;

    }
}

