/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.praxislive.base.AbstractRoot;
import org.praxislive.code.CodeCompilerService;
import org.praxislive.code.LibraryResolver;
import org.praxislive.code.services.tools.CompilerTask;
import org.praxislive.code.services.tools.MessageHandler;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Info;
import org.praxislive.core.Lookup;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.RootHub;
import org.praxislive.core.Value;
import org.praxislive.core.protocols.ComponentProtocol;
import org.praxislive.core.services.LogBuilder;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.services.LogService;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.Services;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PBytes;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PResource;

public class DefaultCompilerService
extends AbstractRoot
implements RootHub.ServiceProvider {
    static final String EXT_CLASSPATH = "ext-classpath";
    private static final ComponentInfo INFO = Info.component(cmp -> cmp.merge(ComponentProtocol.API_INFO).merge(CodeCompilerService.API_INFO).control("libraries", c -> c.readOnlyProperty().output(PArray.class)).control("libraries-all", c -> c.readOnlyProperty().output(PArray.class)).control("libraries-path", c -> c.readOnlyProperty().output(PArray.class)));
    private final Map<String, Control> controls = Map.of("compile", new CompileControl(), "add-libs", new AddLibsControl(), "release", new JavaReleaseControl(), "libraries", (call, router) -> {
        if (call.isRequest()) {
            router.route((Packet)call.reply((Value)this.libs));
        }
    }, "libraries-all", (call, router) -> {
        if (call.isRequest()) {
            router.route((Packet)call.reply((Value)this.libsAll));
        }
    }, "libraries-system", (call, router) -> {
        if (call.isRequest()) {
            router.route((Packet)call.reply((Value)this.libsSys));
        }
    }, "libraries-path", (call, router) -> {
        if (call.isRequest()) {
            router.route((Packet)call.reply((Value)this.libPath));
        }
    }, "info", (call, router) -> {
        if (call.isRequest()) {
            router.route((Packet)call.reply((Value)INFO));
        }
    });
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final Set<PResource> libResolved;
    private final Set<PResource> libProvided;
    private final Set<PResource> libSystem;
    private final Set<Path> libFiles;
    private final List<LibraryResolver> libResolvers;
    private final String defClasspath;
    private final String defModulepath;
    private SourceVersion release;
    private PArray libs;
    private PArray libsAll;
    private PArray libPath;
    private PArray libsSys;

    public DefaultCompilerService() {
        if (this.compiler == null) {
            throw new RuntimeException("No compiler found");
        }
        this.release = SourceVersion.RELEASE_11;
        this.libFiles = new LinkedHashSet<Path>();
        this.libResolved = new LinkedHashSet<PResource>();
        this.libProvided = new LinkedHashSet<PResource>();
        this.libResolvers = ServiceLoader.load(LibraryResolver.Provider.class).stream().map(ServiceLoader.Provider::get).map(LibraryResolver.Provider::createResolver).collect(Collectors.toList());
        this.libs = PArray.EMPTY;
        this.libsAll = PArray.EMPTY;
        this.libPath = PArray.EMPTY;
        List systemProvided = ServiceLoader.load(LibraryResolver.SystemInfo.class).stream().map(ServiceLoader.Provider::get).flatMap(LibraryResolver.SystemInfo::provided).collect(Collectors.toList());
        this.libSystem = new LinkedHashSet(systemProvided);
        this.libsSys = PArray.of(this.libSystem);
        this.defClasspath = System.getProperty("java.class.path", "");
        this.defModulepath = System.getProperty("jdk.module.path", "");
    }

    public List<Class<? extends Service>> services() {
        return List.of(CodeCompilerService.class);
    }

    protected void processCall(Call call, PacketRouter router) {
        try {
            this.controls.get(call.to().controlID()).call(call, router);
        }
        catch (Exception ex) {
            router.route((Packet)call.error(PError.of((Exception)ex)));
        }
    }

    private class CompileControl
    implements Control {
        private CompileControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (!call.isRequest()) {
                throw new UnsupportedOperationException();
            }
            PMap map = (PMap)PMap.from((Value)((Value)call.args().get(0))).orElseThrow();
            PMap ret = this.process(map);
            router.route((Packet)call.reply((Value)ret));
        }

        private PMap process(PMap map) throws Exception {
            PMap sources = (PMap)PMap.from((Value)map.get("sources")).orElseThrow(IllegalArgumentException::new);
            Map<String, String> extractedSources = sources.keys().stream().collect(Collectors.toUnmodifiableMap(k -> k, k -> sources.get(k).toString()));
            LogBuilder log = new LogBuilder(this.getLogLevel(map));
            List<String> options = List.of("-proc:none", "--release", String.valueOf(DefaultCompilerService.this.release.ordinal()), "--add-modules", "ALL-MODULE-PATH", "--module-path", DefaultCompilerService.this.defModulepath, "-classpath", this.buildClasspath());
            Map<String, Supplier<InputStream>> shared = Optional.ofNullable(map.get("shared-classes")).flatMap(PMap::from).map(m -> this.processExistingClasses((PMap)m)).orElse(Map.of());
            Map<String, byte[]> classFiles = CompilerTask.create(extractedSources).existingClasses(shared).options(options).messageHandler(new LogMessageHandler(log)).compile();
            PMap classes = this.convertClasses(classFiles);
            PMap response = PMap.of((String)"classes", (Object)classes, (String)"log", (Object)PArray.of((Collection)log.toList()), (String)DefaultCompilerService.EXT_CLASSPATH, (Object)DefaultCompilerService.this.libPath);
            return response;
        }

        private LogLevel getLogLevel(PMap map) {
            String level = map.getString("log-level", null);
            if (level != null) {
                return LogLevel.valueOf((String)level);
            }
            return LogLevel.WARNING;
        }

        private String buildClasspath() {
            if (DefaultCompilerService.this.libFiles.isEmpty()) {
                return DefaultCompilerService.this.defClasspath;
            }
            Object cp = DefaultCompilerService.this.libFiles.stream().map(p -> p.toAbsolutePath().toString()).collect(Collectors.joining(File.pathSeparator));
            if (!DefaultCompilerService.this.defClasspath.isBlank()) {
                cp = (String)cp + File.pathSeparator + DefaultCompilerService.this.defClasspath;
            }
            return cp;
        }

        private PMap convertClasses(Map<String, byte[]> classes) {
            PMap.Builder bld = PMap.builder();
            classes.entrySet().stream().forEach(type -> bld.put((String)type.getKey(), (Value)PBytes.valueOf((byte[])((byte[])type.getValue()))));
            return bld.build();
        }

        private Map<String, Supplier<InputStream>> processExistingClasses(PMap classes) {
            return classes.keys().stream().map(cls -> Map.entry(cls, () -> PBytes.from((Value)classes.get(cls)).map(PBytes::asInputStream).orElseGet(() -> ((PBytes)PBytes.EMPTY).asInputStream()))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    private class AddLibsControl
    implements Control,
    LibraryResolver.Context {
        private final LogBuilder log = new LogBuilder(LogLevel.INFO);

        private AddLibsControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isRequest()) {
                PArray addLibs = (PArray)PArray.from((Value)((Value)call.args().get(0))).orElseThrow(IllegalArgumentException::new);
                this.process(addLibs);
                if (!this.log.isEmpty()) {
                    this.getLookup().find(Services.class).flatMap(s -> s.locate(LogService.class)).ifPresent(ad -> router.route((Packet)Call.createQuiet((ControlAddress)ControlAddress.of((ComponentAddress)ad, (String)"log"), (ControlAddress)call.to(), (long)call.time(), (List)this.log.toList())));
                    this.log.clear();
                }
                router.route((Packet)call.reply((Value)DefaultCompilerService.this.libs));
            }
        }

        private void process(PArray addLibs) throws Exception {
            for (Value value : addLibs) {
                PResource resource = (PResource)PResource.from((Value)value).orElseThrow(IllegalArgumentException::new);
                if (DefaultCompilerService.this.libResolved.contains(resource)) continue;
                LibraryResolver.Entry entry = this.resolve(resource);
                DefaultCompilerService.this.libResolved.add(entry.resource());
                DefaultCompilerService.this.libProvided.addAll(entry.provides());
                DefaultCompilerService.this.libFiles.addAll(entry.files());
            }
            DefaultCompilerService.this.libs = PArray.of(DefaultCompilerService.this.libResolved);
            DefaultCompilerService.this.libsAll = PArray.of(DefaultCompilerService.this.libProvided);
            DefaultCompilerService.this.libPath = (PArray)DefaultCompilerService.this.libFiles.stream().map(Path::toUri).map(PResource::of).collect(PArray.collector());
        }

        private LibraryResolver.Entry resolve(PResource resource) throws Exception {
            for (LibraryResolver resolver : DefaultCompilerService.this.libResolvers) {
                Optional response = resolver.resolve(resource, (LibraryResolver.Context)this);
                if (!response.isPresent()) continue;
                LibraryResolver.Entry entry = (LibraryResolver.Entry)response.get();
                return entry;
            }
            return new LibraryResolver.Entry(resource, List.of(this.jarFile(resource).toPath()));
        }

        private File jarFile(PResource res) {
            List uris = res.resolve(this.getLookup());
            return uris.stream().filter(u -> "file".equals(u.getScheme())).map(File::new).filter(f -> f.exists() && f.getName().endsWith(".jar")).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid library : " + String.valueOf(res)));
        }

        public Stream<PResource> resolved() {
            return DefaultCompilerService.this.libResolved.stream();
        }

        public Stream<PResource> provided() {
            return Stream.concat(DefaultCompilerService.this.libSystem.stream(), DefaultCompilerService.this.libProvided.stream());
        }

        public Stream<Path> files() {
            return DefaultCompilerService.this.libFiles.stream();
        }

        public LogBuilder log() {
            return this.log;
        }

        public Lookup getLookup() {
            return DefaultCompilerService.this.getLookup();
        }
    }

    private class JavaReleaseControl
    implements Control {
        private JavaReleaseControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isRequest()) {
                int requestedRelease = ((PNumber)PNumber.from((Value)((Value)call.args().get(0))).orElseThrow()).toIntValue();
                this.process(requestedRelease);
                if (call.isReplyRequired()) {
                    router.route((Packet)call.reply(call.args()));
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private void process(int requestedRelease) throws Exception {
            SourceVersion requested;
            if (requestedRelease <= DefaultCompilerService.this.release.ordinal()) {
                return;
            }
            DefaultCompilerService.this.release = requested = DefaultCompilerService.this.compiler.getSourceVersions().stream().filter(v -> v.ordinal() == requestedRelease).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported release version : " + requestedRelease));
        }
    }

    private static class LogMessageHandler
    implements MessageHandler {
        private final LogBuilder log;

        private LogMessageHandler(LogBuilder log) {
            this.log = log;
        }

        @Override
        public void handleError(String msg) {
            this.log.log(LogLevel.ERROR, msg);
        }

        @Override
        public void handleWarning(String msg) {
            this.log.log(LogLevel.WARNING, msg);
        }
    }
}

